<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'username',
        'email',
        'password',
        'is_admin',
        'permissions',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'is_admin' => 'boolean',
        'permissions' => 'json',
    ];

    /**
     * Check if the user has a specific permission.
     *
     * @param string $permission
     * @return bool
     */
    public function hasPermission($permission)
    {
        if ($this->is_admin) {
            return true;
        }

        $permissions = $this->permissions;
        return isset($permissions[$permission]) && $permissions[$permission];
    }

    /**
     * Check if the user is view-only.
     *
     * @return bool
     */
    public function isViewOnly()
    {
        if ($this->is_admin) {
            return false;
        }

        $permissions = $this->permissions;
        $managementPermissions = [
            'manage_certificates',
            'manage_surveys',
            'manage_plans',
        ];

        foreach ($managementPermissions as $permission) {
            if (isset($permissions[$permission]) && $permissions[$permission]) {
                return false;
            }
        }

        return true;
    }
}
