<?php
// Load the Laravel environment
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// Get all vessel certificates with attachments
$certificates = \App\Models\VesselCertificate::whereNotNull('attachment_path')->get();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Delete Attachments Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .btn { padding: 5px 10px; margin: 2px; cursor: pointer; }
        .btn-danger { background-color: #f44336; color: white; border: none; }
        pre { background-color: #f5f5f5; padding: 10px; overflow: auto; }
    </style>
</head>
<body>
    <h1>Certificate Attachments</h1>
    
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Vessel</th>
                <th>Certificate</th>
                <th>Attachment Path</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($certificates as $cert): ?>
            <tr>
                <td><?= $cert->id ?></td>
                <td><?= $cert->vessel ? $cert->vessel->name : 'Unknown' ?></td>
                <td><?= $cert->certificate ? $cert->certificate->name : 'Unknown' ?></td>
                <td>
                    <?php 
                    if (is_string($cert->attachment_path) && !is_array(json_decode($cert->attachment_path, true))) {
                        echo $cert->attachment_path;
                    } else {
                        $attachments = is_array($cert->attachment_path) 
                            ? $cert->attachment_path 
                            : json_decode($cert->attachment_path, true);
                        
                        if (is_array($attachments)) {
                            foreach ($attachments as $index => $path) {
                                echo "[$index] $path<br>";
                            }
                        } else {
                            echo "Invalid format: " . json_encode($cert->attachment_path);
                        }
                    }
                    ?>
                </td>
                <td>
                    <?php 
                    if (is_string($cert->attachment_path) && !is_array(json_decode($cert->attachment_path, true))) {
                    ?>
                        <form action="delete_attachment.php" method="POST" class="delete-form">
                            <input type="hidden" name="vessel_certificate_id" value="<?= $cert->id ?>">
                            <input type="hidden" name="attachment_index" value="0">
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    <?php
                    } else {
                        $attachments = is_array($cert->attachment_path) 
                            ? $cert->attachment_path 
                            : json_decode($cert->attachment_path, true);
                        
                        if (is_array($attachments)) {
                            foreach ($attachments as $index => $path) {
                    ?>
                            <form action="delete_attachment.php" method="POST" class="delete-form">
                                <input type="hidden" name="vessel_certificate_id" value="<?= $cert->id ?>">
                                <input type="hidden" name="attachment_index" value="<?= $index ?>">
                                <button type="submit" class="btn btn-danger">Delete #<?= $index ?></button>
                            </form>
                    <?php
                            }
                        }
                    }
                    ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    
    <div id="result" style="margin-top: 20px;"></div>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const forms = document.querySelectorAll('.delete-form');
        const resultDiv = document.getElementById('result');
        
        forms.forEach(form => {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                
                if (!confirm('Are you sure you want to delete this attachment?')) {
                    return;
                }
                
                const formData = new FormData(form);
                const btn = form.querySelector('button');
                const originalText = btn.innerHTML;
                
                btn.innerHTML = 'Deleting...';
                btn.disabled = true;
                
                fetch(form.action, {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    resultDiv.innerHTML = '<h3>Result:</h3><pre>' + data + '</pre>';
                    
                    try {
                        const jsonData = JSON.parse(data.substring(data.lastIndexOf('{')));
                        if (jsonData.success) {
                            form.innerHTML = '<span style="color: green;">Deleted!</span>';
                        }
                    } catch (e) {
                        console.error('Error parsing JSON:', e);
                    }
                })
                .catch(error => {
                    resultDiv.innerHTML = '<h3>Error:</h3><pre>' + error + '</pre>';
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                });
            });
        });
    });
    </script>
</body>
</html>
