<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\VesselController;
use App\Http\Controllers\CertificateController;
use App\Http\Controllers\UserController;

// Redirect root to login page
Route::get('/', function () {
    if (Auth::check()) {
        return redirect('/dashboard');
    }
    return redirect('/login');
});

// Simple Authentication routes
Route::get('/simple-login', [App\Http\Controllers\Auth\SimpleLoginController::class, 'showLoginForm'])->name('simple.login.form');
Route::post('/simple-login', [App\Http\Controllers\Auth\SimpleLoginController::class, 'login'])->name('simple.login');
Route::post('/simple-logout', [App\Http\Controllers\Auth\SimpleLoginController::class, 'logout'])->name('simple.logout');

// Authentication routes
Auth::routes();

// Dashboard
Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

// Resource routes
Route::middleware(['auth'])->group(function () {
    // Vessels
    Route::resource('vessels', VesselController::class);

    // Certificates
    Route::resource('certificates', CertificateController::class);

    // Particulars
    Route::get('/particulars', function () {
        return redirect()->route('vessels.index');
    })->name('particulars.index');

    // Surveys
    Route::get('/surveys', function () {
        return redirect()->route('vessels.index');
    })->name('surveys.index');

    // Users
    Route::resource('users', UserController::class);

    // Settings
    Route::get('/settings', [App\Http\Controllers\SettingsController::class, 'index'])->name('settings.index');
    Route::put('/settings/warning', [App\Http\Controllers\SettingsController::class, 'updateWarningSettings'])->name('settings.update-warning');
    Route::get('/settings/certificates', [App\Http\Controllers\SettingsController::class, 'certificates'])->name('settings.certificates');
    Route::post('/settings/create-certificate', [App\Http\Controllers\SettingsController::class, 'createCertificate'])->name('settings.create-certificate');
    Route::put('/settings/certificates/{certificate}', [App\Http\Controllers\SettingsController::class, 'updateCertificate'])->name('settings.update-certificate');
    Route::delete('/settings/certificates/{certificate}', [App\Http\Controllers\SettingsController::class, 'destroyCertificate'])->name('settings.destroy-certificate');
    Route::post('/settings/reorder-certificates', [App\Http\Controllers\SettingsController::class, 'reorderCertificates'])->name('settings.reorder-certificates');
    Route::get('/settings/database', [App\Http\Controllers\SettingsController::class, 'database'])->name('settings.database');
    Route::get('/settings/surveys', [App\Http\Controllers\SettingsController::class, 'surveys'])->name('settings.surveys');
    Route::post('/settings/create-survey', [App\Http\Controllers\SettingsController::class, 'createSurvey'])->name('settings.create-survey');
    Route::put('/settings/surveys/{id}', [App\Http\Controllers\SettingsController::class, 'updateSurvey'])->name('settings.update-survey');
    Route::delete('/settings/surveys/{id}', [App\Http\Controllers\SettingsController::class, 'destroySurvey'])->name('settings.destroy-survey');

    // Certificate operations
    Route::post('/certificates/update-date', [CertificateController::class, 'updateDate'])->name('certificates.update-date');
    Route::post('/certificates/update-certificate', [CertificateController::class, 'updateCertificate'])->name('certificates.update-certificate');
    Route::post('/certificates/delete-attachment', [CertificateController::class, 'deleteAttachment'])->name('certificates.delete-attachment');
    Route::post('/vessel-certificates/remove-attachment', [CertificateController::class, 'removeAttachment'])->name('vessel-certificates.remove-attachment');
    Route::post('/vessel-certificates/bulk-download', [CertificateController::class, 'bulkDownload'])->name('vessel-certificates.bulk-download');

    // Vessel Certificate operations
    Route::post('/vessel-certificates', [VesselController::class, 'storeCertificate'])->name('vessel-certificates.store');
    Route::get('/vessel-certificates/{vesselCertificate}/edit', [VesselController::class, 'editCertificate'])->name('vessel-certificates.edit');
    Route::put('/vessel-certificates/{vesselCertificate}', [VesselController::class, 'updateCertificate'])->name('vessel-certificates.update');
    Route::delete('/vessel-certificates/{vesselCertificate}', [VesselController::class, 'destroyCertificate'])->name('vessel-certificates.destroy');
    Route::get('/certificate-file', [VesselController::class, 'viewCertificateFile'])->name('certificate.file');
    Route::get('/certificate-preview', [VesselController::class, 'previewCertificateFile'])->name('certificate.preview');

    // Vessel Plan operations
    Route::post('/vessel-plans', [App\Http\Controllers\VesselPlanController::class, 'store'])->name('vessel-plans.store');
    Route::put('/vessel-plans/{vesselPlan}', [App\Http\Controllers\VesselPlanController::class, 'update'])->name('vessel-plans.update');
    Route::delete('/vessel-plans/{vesselPlan}', [App\Http\Controllers\VesselPlanController::class, 'destroy'])->name('vessel-plans.destroy');

    // Vessel Survey operations
    Route::post('/vessel-surveys', [App\Http\Controllers\VesselSurveyController::class, 'store'])->name('vessel-surveys.store');
    Route::put('/vessel-surveys/{vesselSurvey}', [App\Http\Controllers\VesselSurveyController::class, 'update'])->name('vessel-surveys.update');
    Route::delete('/vessel-surveys/{vesselSurvey}', [App\Http\Controllers\VesselSurveyController::class, 'destroy'])->name('vessel-surveys.destroy');

    // Vessel Particulars operations
    Route::post('/vessel-particulars', [App\Http\Controllers\VesselParticularsController::class, 'store'])->name('vessel-particulars.store');
    Route::put('/vessel-particulars/{vesselParticular}', [App\Http\Controllers\VesselParticularsController::class, 'update'])->name('vessel-particulars.update');
    Route::delete('/vessel-particulars/{vesselParticular}', [App\Http\Controllers\VesselParticularsController::class, 'destroy'])->name('vessel-particulars.destroy');
});

// Redirect /home to /dashboard for consistency
Route::get('/home', function () {
    return redirect('/dashboard');
});
