<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-12">
            <h2>System Settings</h2>
        </div>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <ul class="nav nav-tabs mb-4" id="settingsTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="true">
                <i class="fas fa-cog"></i> General Settings
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="certificates-tab" data-bs-toggle="tab" data-bs-target="#certificates" type="button" role="tab" aria-controls="certificates" aria-selected="false">
                <i class="fas fa-certificate"></i> Certificates
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="system-tab" data-bs-toggle="tab" data-bs-target="#system" type="button" role="tab" aria-controls="system" aria-selected="false">
                <i class="fas fa-info-circle"></i> System Info
            </button>
        </li>
    </ul>

    <div class="tab-content" id="settingsTabsContent">
        <!-- General Settings Tab -->
        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab">
            <div class="card">
                <div class="card-header">
                    <h5>Warning Settings</h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('settings.update-warning')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="warning_days" class="form-label">Certificate Warning Days</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['warning_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="warning_days" name="warning_days" value="<?php echo e(old('warning_days', $settings->warning_days ?? 30)); ?>" min="1" required>
                                    <div class="form-text">Number of days before expiry to show warning status</div>
                                    <?php $__errorArgs = ['warning_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="danger_days" class="form-label">Certificate Danger Days</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['danger_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="danger_days" name="danger_days" value="<?php echo e(old('danger_days', $settings->danger_days ?? 7)); ?>" min="1" required>
                                    <div class="form-text">Number of days before expiry to show danger status</div>
                                    <?php $__errorArgs = ['danger_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="survey_warning_days" class="form-label">Survey Warning Days</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['survey_warning_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="survey_warning_days" name="survey_warning_days" value="<?php echo e(old('survey_warning_days', $settings->survey_warning_days ?? 90)); ?>" min="1" required>
                                    <div class="form-text">Number of days before due date to show warning status</div>
                                    <?php $__errorArgs = ['survey_warning_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="survey_danger_days" class="form-label">Survey Danger Days</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['survey_danger_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="survey_danger_days" name="survey_danger_days" value="<?php echo e(old('survey_danger_days', $settings->survey_danger_days ?? 30)); ?>" min="1" required>
                                    <div class="form-text">Number of days before due date to show danger status</div>
                                    <?php $__errorArgs = ['survey_danger_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Certificates Tab -->
        <div class="tab-pane fade" id="certificates" role="tabpanel" aria-labelledby="certificates-tab">
            <div class="row">
                <div class="col-md-12 mb-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Create New Certificate</h5>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('settings.create-certificate')); ?>" method="POST" class="row g-3">
                                <?php echo csrf_field(); ?>
                                <div class="col-md-5">
                                    <label for="name" class="form-label">Certificate Name</label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="name" name="name" required>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-5">
                                    <label for="category" class="form-label">Category</label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="category" name="category" required list="categories">
                                    <datalist id="categories">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category); ?>">
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </datalist>
                                    <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-plus-circle"></i> Create
                                    </button>
                                </div>
                                <div class="col-md-12">
                                    <small class="text-muted">New certificates are automatically added to all vessels.</small>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>



            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Certificate Reordering</h5>
                            <div>
                                <button id="saveOrderBtn" class="btn btn-success btn-sm" style="display: none;">
                                    <i class="fas fa-save"></i> Save Order
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> Drag and drop certificates to reorder them. Changes will be applied to all vessels.
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th width="5%">#</th>
                                            <th width="30%">Category</th>
                                            <th width="50%">Certificate Name</th>
                                            <th width="15%">Display Order</th>
                                        </tr>
                                    </thead>
                                    <tbody id="certificatesTableBody">
                                        <?php $__currentLoopData = $certificates->groupBy('category'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $categoryCertificates): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $categoryCertificates->sortBy('display_order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="certificate-row" data-id="<?php echo e($certificate->id); ?>" data-order="<?php echo e($certificate->display_order); ?>">
                                                    <td><?php echo e($loop->parent->index + 1); ?>.<?php echo e($loop->index + 1); ?></td>
                                                    <td><?php echo e($category); ?></td>
                                                    <td><?php echo e($certificate->name); ?></td>
                                                    <td>
                                                        <span class="order-display"><?php echo e($certificate->display_order); ?></span>
                                                        <input type="hidden" class="order-input" value="<?php echo e($certificate->display_order); ?>">
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Info Tab -->
        <div class="tab-pane fade" id="system" role="tabpanel" aria-labelledby="system-tab">
            <div class="card">
                <div class="card-header">
                    <h5>System Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Laravel Version:</strong> <?php echo e(app()->version()); ?></p>
                            <p><strong>PHP Version:</strong> <?php echo e(phpversion()); ?></p>
                            <p><strong>Database:</strong> <?php echo e(config('database.default')); ?></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Total Vessels:</strong> <?php echo e(\App\Models\Vessel::count()); ?></p>
                            <p><strong>Total Certificates:</strong> <?php echo e(\App\Models\Certificate::count()); ?></p>
                            <p><strong>Total Users:</strong> <?php echo e(\App\Models\User::count()); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.14.0/Sortable.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Sortable for the certificates table
    const certificatesTableBody = document.getElementById('certificatesTableBody');
    const saveOrderBtn = document.getElementById('saveOrderBtn');

    if (certificatesTableBody) {
        let sortable = new Sortable(certificatesTableBody, {
            animation: 150,
            handle: '.certificate-row',
            ghostClass: 'bg-light',
            onEnd: function() {
                // Update order numbers
                updateOrderNumbers();
                // Show save button
                saveOrderBtn.style.display = 'inline-block';
            }
        });

        // Function to update order numbers
        function updateOrderNumbers() {
            const rows = certificatesTableBody.querySelectorAll('.certificate-row');
            rows.forEach((row, index) => {
                const orderDisplay = row.querySelector('.order-display');
                const orderInput = row.querySelector('.order-input');

                orderDisplay.textContent = index + 1;
                orderInput.value = index + 1;
            });
        }

        // Save order button click handler
        if (saveOrderBtn) {
            saveOrderBtn.addEventListener('click', function() {
                const rows = certificatesTableBody.querySelectorAll('.certificate-row');
                const certificates = [];

                rows.forEach(row => {
                    certificates.push({
                        id: row.dataset.id,
                        display_order: row.querySelector('.order-input').value
                    });
                });

                // Send AJAX request to save order
                fetch('<?php echo e(route("settings.reorder-certificates")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ certificates: certificates })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Show success message
                        alert('Certificate order saved successfully!');
                        // Hide save button
                        saveOrderBtn.style.display = 'none';
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('An error occurred while saving the certificate order.');
                });
            });
        }
    }

    // Activate tab based on hash in URL
    const hash = window.location.hash;
    if (hash) {
        const tab = document.querySelector(`#settingsTabs button[data-bs-target="${hash}"]`);
        if (tab) {
            const bsTab = new bootstrap.Tab(tab);
            bsTab.show();
        }
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ASUS\Desktop\vessel-certificates\resources\views/settings/index.blade.php ENDPATH**/ ?>