<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h2><?php echo e($vessel->name); ?></h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo e(route('vessels.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Vessels
            </a>

            <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
            <a href="<?php echo e(route('vessels.edit', $vessel)); ?>" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit Vessel
            </a>
            <?php endif; ?>
        </div>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-12">
            <ul class="nav nav-tabs" id="vesselTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="certificates-tab" data-bs-toggle="tab" data-bs-target="#certificates" type="button" role="tab" aria-controls="certificates" aria-selected="true">
                        <i class="fas fa-certificate"></i> Certificates
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="particulars-tab" data-bs-toggle="tab" data-bs-target="#particulars" type="button" role="tab" aria-controls="particulars" aria-selected="false">
                        <i class="fas fa-info-circle"></i> Particulars
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="plans-tab" data-bs-toggle="tab" data-bs-target="#plans" type="button" role="tab" aria-controls="plans" aria-selected="false">
                        <i class="fas fa-map"></i> Plans
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="surveys-tab" data-bs-toggle="tab" data-bs-target="#surveys" type="button" role="tab" aria-controls="surveys" aria-selected="false">
                        <i class="fas fa-clipboard-check"></i> Surveys
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="vesselTabsContent">
                <!-- Certificates Tab -->
                <div class="tab-pane fade show active" id="certificates" role="tabpanel" aria-labelledby="certificates-tab">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>Certificates (<?php echo e($filledCertificateCount); ?>)</h5>
                                </div>
                                <div class="col-md-6 text-end">
                                    <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCertificateModal">
                                        <i class="fas fa-plus"></i> Add Certificate
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <button class="btn btn-sm btn-success" id="exportToExcel">
                                    <i class="fas fa-file-excel"></i> Export to Excel
                                </button>
                                <button class="btn btn-sm btn-primary" id="toggleEmptyCertificates">
                                    <i class="fas fa-eye"></i> Show/Hide Empty Certificates
                                </button>

                                <!-- Bulk Download Controls -->
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-sm btn-info dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fas fa-download"></i> Bulk Download
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="#" id="downloadSelected">Download Selected</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><h6 class="dropdown-header">Download by Category</h6></li>
                                        <?php
                                            $categories = $certificates->pluck('category')->unique()->sort();
                                        ?>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a class="dropdown-item download-category" href="#" data-category="<?php echo e($category); ?>"><?php echo e($category); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>

                                <button class="btn btn-sm btn-secondary" id="selectAll">
                                    <i class="fas fa-check-square"></i> Select All
                                </button>
                                <button class="btn btn-sm btn-secondary" id="deselectAll">
                                    <i class="fas fa-square"></i> Deselect All
                                </button>

                                <span class="selected-count ms-3" id="selectedCount">0 selected</span>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-striped table-hover" id="certificatesTable">
                                    <thead>
                                        <tr>
                                            <th>
                                                <input type="checkbox" id="selectAllCheckbox" class="form-check-input">
                                            </th>
                                            <th>Category</th>
                                            <th>Certificate</th>
                                            <th>ID No.</th>
                                            <th>Department</th>
                                            <th>Issued Date</th>
                                            <th>Expiry Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            // Group certificates by category
                                            $certificatesByCategory = [];
                                            foreach ($certificates as $cert) {
                                                if (!isset($certificatesByCategory[$cert->category])) {
                                                    $certificatesByCategory[$cert->category] = [];
                                                }
                                                $certificatesByCategory[$cert->category][] = $cert;
                                            }

                                            // Sort categories by category_order
                                            ksort($certificatesByCategory);
                                        ?>

                                        <?php $__currentLoopData = $certificatesByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $categoryCertificates): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="category-header bg-dark text-white">
                                                <td colspan="9" class="py-2">
                                                    <h5 class="mb-0"><i class="fas fa-folder me-2"></i> CATEGORY: <?php echo e($category); ?></h5>
                                                </td>
                                            </tr>

                                            <?php $__currentLoopData = $categoryCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $vesselCert = $vessel->vesselCertificates->where('certificate_id', $certificate->id)->first();
                                                    $isEmpty = !$vesselCert || (!$vesselCert->id_no && !$vesselCert->vessel_department && !$vesselCert->issued_date && !$vesselCert->expiry_date);
                                                ?>

                                                <tr class="<?php echo e($isEmpty ? 'empty-certificate' : ''); ?>" data-category="<?php echo e($category); ?>">
                                                    <td>
                                                        <?php if($vesselCert && $vesselCert->attachment_path): ?>
                                                            <input type="checkbox" class="form-check-input certificate-checkbox"
                                                                   data-cert-id="<?php echo e($vesselCert->id); ?>"
                                                                   data-category="<?php echo e($category); ?>"
                                                                   data-vessel-name="<?php echo e($vessel->name); ?>"
                                                                   data-cert-name="<?php echo e($certificate->name); ?>">
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($category); ?></td>
                                                    <td><?php echo e($certificate->name); ?></td>
                                                    <td><?php echo e($vesselCert->id_no ?? '-'); ?></td>
                                                    <td><?php echo e($vesselCert->vessel_department ?? '-'); ?></td>
                                                    <td><?php echo e($vesselCert && $vesselCert->issued_date ? $vesselCert->issued_date->format('Y-m-d') : '-'); ?></td>
                                                    <td><?php echo e($vesselCert && $vesselCert->expiry_date ? $vesselCert->expiry_date->format('Y-m-d') : '-'); ?></td>
                                                    <td>
                                                        <?php if($vesselCert && $vesselCert->expiry_date): ?>
                                                            <?php
                                                                $warningSettings = \App\Models\WarningSettings::first();
                                                                $warningDays = $warningSettings ? $warningSettings->warning_days : 30;
                                                                $dangerDays = $warningSettings ? $warningSettings->danger_days : 7;
                                                                $daysUntilExpiry = now()->diffInDays($vesselCert->expiry_date, false);
                                                            ?>
                                                            <?php if($vesselCert->expiry_date < now()): ?>
                                                                <span class="badge bg-danger" title="Expired <?php echo e(abs($daysUntilExpiry)); ?> days ago">Expired</span>
                                                            <?php elseif($vesselCert->expiry_date < now()->addDays($dangerDays)): ?>
                                                                <span class="badge bg-danger" title="Expires in <?php echo e($daysUntilExpiry); ?> days (Danger: <?php echo e($dangerDays); ?> days)">Expiring Soon</span>
                                                            <?php elseif($vesselCert->expiry_date < now()->addDays($warningDays)): ?>
                                                                <span class="badge bg-warning text-dark" title="Expires in <?php echo e($daysUntilExpiry); ?> days (Warning: <?php echo e($warningDays); ?> days)">Expiring Soon</span>
                                                            <?php else: ?>
                                                                <span class="badge bg-success" title="Expires in <?php echo e($daysUntilExpiry); ?> days">Valid</span>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <span class="badge bg-secondary">No Expiry</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <?php if($vesselCert): ?>
                                                                <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#viewCertificateModal<?php echo e($vesselCert->id); ?>">
                                                                    <i class="fas fa-eye"></i> View
                                                                </button>

                                                                <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
                                                                <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editCertificateModal<?php echo e($vesselCert->id); ?>">
                                                                    <i class="fas fa-edit"></i> Edit
                                                                </button>
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
                                                                <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addCertificateModal"
                                                                        onclick="document.getElementById('certificate_id').value = '<?php echo e($certificate->id); ?>'">
                                                                    <i class="fas fa-plus"></i> Add
                                                                </button>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                // Toggle empty certificates
                                const toggleBtn = document.getElementById('toggleEmptyCertificates');
                                toggleBtn.addEventListener('click', function() {
                                    const emptyCerts = document.querySelectorAll('.empty-certificate');
                                    emptyCerts.forEach(cert => {
                                        cert.style.display = cert.style.display === 'none' ? '' : 'none';
                                    });
                                });

                                // Export to Excel
                                document.getElementById('exportToExcel').addEventListener('click', function() {
                                    // Create a workbook
                                    const wb = XLSX.utils.book_new();

                                    // Get the table
                                    const table = document.getElementById('certificatesTable');

                                    // Convert table to worksheet
                                    const ws = XLSX.utils.table_to_sheet(table);

                                    // Add worksheet to workbook
                                    XLSX.utils.book_append_sheet(wb, ws, 'Certificates');

                                    // Save workbook
                                    XLSX.writeFile(wb, '<?php echo e($vessel->name); ?>_Certificates.xlsx');
                                });
                            });
                        </script>
                    </div>
                </div>

                <!-- Particulars Tab -->
                <div class="tab-pane fade" id="particulars" role="tabpanel" aria-labelledby="particulars-tab">
                    <div class="card">
                        <div class="card-header">
                            <h5>Vessel Particulars</h5>
                        </div>
                        <div class="card-body">
                            <?php if($vessel->particulars): ?>
                                <div class="row mb-3">
                                    <div class="col-md-3">
                                        <strong>IMO Number:</strong>
                                    </div>
                                    <div class="col-md-9">
                                        <?php echo e($vessel->particulars->imo_number ?? 'Not specified'); ?>

                                    </div>
                                </div>

                                <?php if($vessel->particulars->attachment_path): ?>
                                <div class="row mb-3">
                                    <div class="col-md-3">
                                        <strong>Attachment:</strong>
                                    </div>
                                    <div class="col-md-9">
                                        <a href="<?php echo e(asset('storage/' . $vessel->particulars->attachment_path)); ?>" target="_blank" class="btn btn-sm btn-primary">
                                            <i class="fas fa-download"></i> Download Particulars
                                        </a>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="row mb-3">
                                    <div class="col-md-12">
                                        <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
                                        <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#editParticularsModal">
                                            <i class="fas fa-edit"></i> Edit Particulars
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php else: ?>
                                <p>No particulars information available for this vessel.</p>

                                <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addParticularsModal">
                                    <i class="fas fa-plus"></i> Add Particulars
                                </button>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Plans Tab -->
                <div class="tab-pane fade" id="plans" role="tabpanel" aria-labelledby="plans-tab">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>Vessel Plans</h5>
                                </div>
                                <div class="col-md-6 text-end">
                                    <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_plans')): ?>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPlanModal">
                                        <i class="fas fa-plus"></i> Add Plan
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Plan</th>
                                            <th>Category</th>
                                            <th>Attachment</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $vessel->vesselPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vesselPlan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($vesselPlan->plan->name); ?></td>
                                            <td><?php echo e($vesselPlan->plan->category); ?></td>
                                            <td>
                                                <?php if($vesselPlan->attachment_path): ?>
                                                <a href="<?php echo e(asset('storage/' . $vesselPlan->attachment_path)); ?>" target="_blank" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-download"></i> Download
                                                </a>
                                                <?php else: ?>
                                                <span class="text-muted">No attachment</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_plans')): ?>
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editPlanModal<?php echo e($vesselPlan->id); ?>">
                                                        <i class="fas fa-edit"></i> Edit
                                                    </button>

                                                    <button type="button" class="btn btn-sm btn-danger"
                                                            onclick="if(confirm('Are you sure you want to delete this plan?')) {
                                                                document.getElementById('delete-plan-<?php echo e($vesselPlan->id); ?>').submit();
                                                            }">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>

                                                    <form id="delete-plan-<?php echo e($vesselPlan->id); ?>" action="<?php echo e(route('vessel-plans.destroy', $vesselPlan)); ?>" method="POST" style="display: none;">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                    </form>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4" class="text-center">No plans found for this vessel.</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Surveys Tab -->
                <div class="tab-pane fade" id="surveys" role="tabpanel" aria-labelledby="surveys-tab">
                    <div class="card">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>Vessel Surveys</h5>
                                </div>
                                <div class="col-md-6 text-end">
                                    <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_surveys')): ?>
                                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSurveyModal">
                                        <i class="fas fa-plus"></i> Add Survey
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>Survey</th>
                                            <th>Category</th>
                                            <th>Last Date</th>
                                            <th>Due Date</th>
                                            <th>Window Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $vessel->vesselSurveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vesselSurvey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($vesselSurvey->survey->name); ?></td>
                                            <td><?php echo e($vesselSurvey->survey->category); ?></td>
                                            <td><?php echo e($vesselSurvey->last_date ? $vesselSurvey->last_date->format('Y-m-d') : '-'); ?></td>
                                            <td><?php echo e($vesselSurvey->due_date ? $vesselSurvey->due_date->format('Y-m-d') : '-'); ?></td>
                                            <td><?php echo e($vesselSurvey->window_date ? $vesselSurvey->window_date->format('Y-m-d') : '-'); ?></td>
                                            <td>
                                                <?php if($vesselSurvey->due_date): ?>
                                                    <?php if($vesselSurvey->due_date < now()): ?>
                                                        <span class="badge bg-danger">Overdue</span>
                                                    <?php elseif($vesselSurvey->due_date < now()->addDays(90)): ?>
                                                        <span class="badge bg-warning text-dark">Due Soon</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-success">Scheduled</span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary">No Due Date</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#viewSurveyModal<?php echo e($vesselSurvey->id); ?>">
                                                        <i class="fas fa-eye"></i> View
                                                    </button>

                                                    <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_surveys')): ?>
                                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editSurveyModal<?php echo e($vesselSurvey->id); ?>">
                                                        <i class="fas fa-edit"></i> Edit
                                                    </button>

                                                    <button type="button" class="btn btn-sm btn-danger"
                                                            onclick="if(confirm('Are you sure you want to delete this survey?')) {
                                                                document.getElementById('delete-survey-<?php echo e($vesselSurvey->id); ?>').submit();
                                                            }">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>

                                                    <form id="delete-survey-<?php echo e($vesselSurvey->id); ?>" action="<?php echo e(route('vessel-surveys.destroy', $vesselSurvey)); ?>" method="POST" style="display: none;">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                    </form>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" class="text-center">No surveys found for this vessel.</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modals -->

<!-- Add Certificate Modal -->
<div class="modal fade" id="addCertificateModal" tabindex="-1" aria-labelledby="addCertificateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addCertificateModalLabel">Add Certificate</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-certificates.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="vessel_id" value="<?php echo e($vessel->id); ?>">

                    <div class="mb-3">
                        <label for="certificate_id" class="form-label">Certificate</label>
                        <select class="form-select" id="certificate_id" name="certificate_id" required>
                            <option value="">Select Certificate</option>
                            <?php $__currentLoopData = $certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($certificate->id); ?>"><?php echo e($certificate->name); ?> (<?php echo e($certificate->category); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="id_no" class="form-label">ID Number</label>
                        <input type="text" class="form-control" id="id_no" name="id_no">
                    </div>

                    <div class="mb-3">
                        <label for="vessel_department" class="form-label">Department</label>
                        <input type="text" class="form-control" id="vessel_department" name="vessel_department">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="issued_date" class="form-label">Issued Date</label>
                                <input type="date" class="form-control" id="issued_date" name="issued_date">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="expiry_date" class="form-label">Expiry Date</label>
                                <input type="date" class="form-control" id="expiry_date" name="expiry_date">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="attachment" class="form-label">Attachments</label>
                        <input type="file" class="form-control" id="attachment" name="attachments[]" multiple>
                        <div class="form-text">You can select multiple files at once</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Certificate</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Particulars Modal -->
<div class="modal fade" id="addParticularsModal" tabindex="-1" aria-labelledby="addParticularsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addParticularsModalLabel">Add Vessel Particulars</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-particulars.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="vessel_id" value="<?php echo e($vessel->id); ?>">

                    <div class="mb-3">
                        <label for="imo_number" class="form-label">IMO Number</label>
                        <input type="text" class="form-control" id="imo_number" name="imo_number">
                    </div>

                    <div class="mb-3">
                        <label for="attachment" class="form-label">Attachment</label>
                        <input type="file" class="form-control" id="attachment" name="attachment">
                        <div class="form-text">Upload vessel particulars document (PDF, DOC, etc.)</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Particulars</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Particulars Modal -->
<?php if($vessel->particulars): ?>
<div class="modal fade" id="editParticularsModal" tabindex="-1" aria-labelledby="editParticularsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editParticularsModalLabel">Edit Vessel Particulars</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-particulars.update', $vessel->particulars)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_imo_number" class="form-label">IMO Number</label>
                        <input type="text" class="form-control" id="edit_imo_number" name="imo_number" value="<?php echo e($vessel->particulars->imo_number); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="edit_attachment" class="form-label">Attachment</label>
                        <input type="file" class="form-control" id="edit_attachment" name="attachment">
                        <div class="form-text">Upload new vessel particulars document (PDF, DOC, etc.)</div>

                        <?php if($vessel->particulars->attachment_path): ?>
                        <div class="mt-2">
                            <strong>Current attachment:</strong>
                            <a href="<?php echo e(asset('storage/' . $vessel->particulars->attachment_path)); ?>" target="_blank">
                                View current attachment
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Particulars</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Add Plan Modal -->
<div class="modal fade" id="addPlanModal" tabindex="-1" aria-labelledby="addPlanModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPlanModalLabel">Add Plan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-plans.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="vessel_id" value="<?php echo e($vessel->id); ?>">

                    <div class="mb-3">
                        <label for="plan_id" class="form-label">Plan</label>
                        <select class="form-select" id="plan_id" name="plan_id" required>
                            <option value="">Select Plan</option>
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->name); ?> (<?php echo e($plan->category); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="attachment" class="form-label">Attachment</label>
                        <input type="file" class="form-control" id="attachment" name="attachment">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Plan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Survey Modal -->
<div class="modal fade" id="addSurveyModal" tabindex="-1" aria-labelledby="addSurveyModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addSurveyModalLabel">Add Survey</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-surveys.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="vessel_id" value="<?php echo e($vessel->id); ?>">

                    <div class="mb-3">
                        <label for="survey_id" class="form-label">Survey</label>
                        <select class="form-select" id="survey_id" name="survey_id" required>
                            <option value="">Select Survey</option>
                            <?php $__currentLoopData = $surveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($survey->id); ?>"><?php echo e($survey->name); ?> (<?php echo e($survey->category); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="last_date" class="form-label">Last Date</label>
                                <input type="date" class="form-control" id="last_date" name="last_date">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date" class="form-label">Due Date</label>
                                <input type="date" class="form-control" id="due_date" name="due_date">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="window_date" class="form-label">Window Date</label>
                        <input type="date" class="form-control" id="window_date" name="window_date">
                    </div>

                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <input type="text" class="form-control" id="status" name="status">
                    </div>

                    <div class="mb-3">
                        <label for="general_note" class="form-label">General Note</label>
                        <textarea class="form-control" id="general_note" name="general_note" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Survey</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Plan Modals -->
<?php $__currentLoopData = $vessel->vesselPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vesselPlan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editPlanModal<?php echo e($vesselPlan->id); ?>" tabindex="-1" aria-labelledby="editPlanModalLabel<?php echo e($vesselPlan->id); ?>" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPlanModalLabel<?php echo e($vesselPlan->id); ?>">Edit Plan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-plans.update', $vesselPlan)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="plan_id<?php echo e($vesselPlan->id); ?>" class="form-label">Plan</label>
                        <select class="form-select" id="plan_id<?php echo e($vesselPlan->id); ?>" name="plan_id" required>
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($plan->id); ?>" <?php echo e($vesselPlan->plan_id == $plan->id ? 'selected' : ''); ?>>
                                <?php echo e($plan->name); ?> (<?php echo e($plan->category); ?>)
                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="attachment<?php echo e($vesselPlan->id); ?>" class="form-label">Attachment</label>
                        <input type="file" class="form-control" id="attachment<?php echo e($vesselPlan->id); ?>" name="attachment">
                        <div class="form-text">Upload new plan document (PDF, DOC, etc.)</div>

                        <?php if($vesselPlan->attachment_path): ?>
                        <div class="mt-2">
                            <strong>Current attachment:</strong>
                            <a href="<?php echo e(asset('storage/' . $vesselPlan->attachment_path)); ?>" target="_blank">
                                View current attachment
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Plan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- Edit Survey Modals -->
<?php $__currentLoopData = $vessel->vesselSurveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vesselSurvey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editSurveyModal<?php echo e($vesselSurvey->id); ?>" tabindex="-1" aria-labelledby="editSurveyModalLabel<?php echo e($vesselSurvey->id); ?>" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editSurveyModalLabel<?php echo e($vesselSurvey->id); ?>">Edit Survey</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-surveys.update', $vesselSurvey)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="survey_id<?php echo e($vesselSurvey->id); ?>" class="form-label">Survey</label>
                        <select class="form-select" id="survey_id<?php echo e($vesselSurvey->id); ?>" name="survey_id" required>
                            <?php $__currentLoopData = $surveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($survey->id); ?>" <?php echo e($vesselSurvey->survey_id == $survey->id ? 'selected' : ''); ?>>
                                <?php echo e($survey->name); ?> (<?php echo e($survey->category); ?>)
                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="last_date<?php echo e($vesselSurvey->id); ?>" class="form-label">Last Date</label>
                                <input type="date" class="form-control" id="last_date<?php echo e($vesselSurvey->id); ?>" name="last_date" value="<?php echo e($vesselSurvey->last_date ? $vesselSurvey->last_date->format('Y-m-d') : ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date<?php echo e($vesselSurvey->id); ?>" class="form-label">Due Date</label>
                                <input type="date" class="form-control" id="due_date<?php echo e($vesselSurvey->id); ?>" name="due_date" value="<?php echo e($vesselSurvey->due_date ? $vesselSurvey->due_date->format('Y-m-d') : ''); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="window_date<?php echo e($vesselSurvey->id); ?>" class="form-label">Window Date</label>
                        <input type="date" class="form-control" id="window_date<?php echo e($vesselSurvey->id); ?>" name="window_date" value="<?php echo e($vesselSurvey->window_date ? $vesselSurvey->window_date->format('Y-m-d') : ''); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="status<?php echo e($vesselSurvey->id); ?>" class="form-label">Status</label>
                        <input type="text" class="form-control" id="status<?php echo e($vesselSurvey->id); ?>" name="status" value="<?php echo e($vesselSurvey->status); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="general_note<?php echo e($vesselSurvey->id); ?>" class="form-label">General Note</label>
                        <textarea class="form-control" id="general_note<?php echo e($vesselSurvey->id); ?>" name="general_note" rows="3"><?php echo e($vesselSurvey->general_note); ?></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Survey</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Survey Modals -->
<div class="modal fade" id="viewSurveyModal<?php echo e($vesselSurvey->id); ?>" tabindex="-1" aria-labelledby="viewSurveyModalLabel<?php echo e($vesselSurvey->id); ?>" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewSurveyModalLabel<?php echo e($vesselSurvey->id); ?>">
                    <?php echo e($vesselSurvey->survey->name); ?>

                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Survey:</strong>
                    </div>
                    <div class="col-md-8">
                        <?php echo e($vesselSurvey->survey->name); ?> (<?php echo e($vesselSurvey->survey->category); ?>)
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Last Date:</strong>
                    </div>
                    <div class="col-md-8">
                        <?php echo e($vesselSurvey->last_date ? $vesselSurvey->last_date->format('Y-m-d') : 'Not specified'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Due Date:</strong>
                    </div>
                    <div class="col-md-8">
                        <?php echo e($vesselSurvey->due_date ? $vesselSurvey->due_date->format('Y-m-d') : 'Not specified'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Window Date:</strong>
                    </div>
                    <div class="col-md-8">
                        <?php echo e($vesselSurvey->window_date ? $vesselSurvey->window_date->format('Y-m-d') : 'Not specified'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>Status:</strong>
                    </div>
                    <div class="col-md-8">
                        <?php if($vesselSurvey->status): ?>
                            <?php echo e($vesselSurvey->status); ?>

                        <?php else: ?>
                            <?php if($vesselSurvey->due_date): ?>
                                <?php if($vesselSurvey->due_date < now()): ?>
                                    <span class="badge bg-danger">Overdue</span>
                                <?php elseif($vesselSurvey->due_date < now()->addDays(90)): ?>
                                    <span class="badge bg-warning text-dark">Due Soon</span>
                                <?php else: ?>
                                    <span class="badge bg-success">Scheduled</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge bg-secondary">No Due Date</span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($vesselSurvey->general_note): ?>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <strong>General Note:</strong>
                    </div>
                    <div class="col-md-8">
                        <?php echo e($vesselSurvey->general_note); ?>

                    </div>
                </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- View Certificate Modals -->
<?php $__currentLoopData = $vessel->vesselCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vesselCert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="viewCertificateModal<?php echo e($vesselCert->id); ?>" tabindex="-1" aria-labelledby="viewCertificateModalLabel<?php echo e($vesselCert->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewCertificateModalLabel<?php echo e($vesselCert->id); ?>">
                    <?php if($vesselCert->certificate): ?>
                        <?php echo e($vesselCert->certificate->name); ?>

                    <?php else: ?>
                        Certificate Details
                    <?php endif; ?>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Certificate:</strong>
                    </div>
                    <div class="col-md-9">
                        <?php if($vesselCert->certificate): ?>
                            <?php echo e($vesselCert->certificate->name); ?> (<?php echo e($vesselCert->certificate->category); ?>)
                        <?php else: ?>
                            <span class="text-danger">Missing Certificate Type</span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>ID Number:</strong>
                    </div>
                    <div class="col-md-9">
                        <?php echo e($vesselCert->id_no ?: 'Not specified'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Department:</strong>
                    </div>
                    <div class="col-md-9">
                        <?php echo e($vesselCert->vessel_department ?: 'Not specified'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Issued Date:</strong>
                    </div>
                    <div class="col-md-9">
                        <?php echo e($vesselCert->issued_date ? $vesselCert->issued_date->format('Y-m-d') : 'Not specified'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Expiry Date:</strong>
                    </div>
                    <div class="col-md-9">
                        <?php echo e($vesselCert->expiry_date ? $vesselCert->expiry_date->format('Y-m-d') : 'Not specified'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Status:</strong>
                    </div>
                    <div class="col-md-9">
                        <?php if($vesselCert->expiry_date): ?>
                            <?php if($vesselCert->expiry_date < now()): ?>
                                <span class="badge bg-danger">Expired</span>
                            <?php elseif($vesselCert->expiry_date < now()->addDays(30)): ?>
                                <span class="badge bg-warning text-dark">Expiring Soon</span>
                            <?php else: ?>
                                <span class="badge bg-success">Valid</span>
                            <?php endif; ?>
                        <?php else: ?>
                            <span class="badge bg-secondary">No Expiry</span>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($vesselCert->attachment_path): ?>
                <div class="row mb-3">
                    <div class="col-md-3">
                        <strong>Attachments:</strong>
                    </div>
                    <div class="col-md-9">
                        <?php
                            $attachments = json_decode($vesselCert->attachment_path, true);
                        ?>

                        <?php if(is_array($attachments)): ?>
                            <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-2">
                                    <?php
                                        $attachmentPath = $attachment;
                                    ?>
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('certificate.preview', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <a href="<?php echo e(route('certificate.file', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-primary">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <?php
                                $attachmentPath = $vesselCert->attachment_path;
                            ?>
                            <div class="btn-group">
                                <a href="<?php echo e(route('certificate.preview', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i> View
                                </a>
                                <a href="<?php echo e(route('certificate.file', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-primary">
                                    <i class="fas fa-download"></i> Download
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                <?php if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates')): ?>
                <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#editCertificateModal<?php echo e($vesselCert->id); ?>" data-bs-dismiss="modal">
                    <i class="fas fa-edit"></i> Edit
                </button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Edit Certificate Modal -->
<div class="modal fade" id="editCertificateModal<?php echo e($vesselCert->id); ?>" tabindex="-1" aria-labelledby="editCertificateModalLabel<?php echo e($vesselCert->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editCertificateModalLabel<?php echo e($vesselCert->id); ?>">
                    Edit Certificate:
                    <?php if($vesselCert->certificate): ?>
                        <?php echo e($vesselCert->certificate->name); ?>

                    <?php else: ?>
                        Unknown Certificate
                    <?php endif; ?>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('vessel-certificates.update', $vesselCert)); ?>" method="POST" enctype="multipart/form-data" id="update-certificate-form-<?php echo e($vesselCert->id); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="id_no<?php echo e($vesselCert->id); ?>" class="form-label">ID Number</label>
                        <input type="text" class="form-control" id="id_no<?php echo e($vesselCert->id); ?>" name="id_no" value="<?php echo e($vesselCert->id_no); ?>">
                    </div>

                    <div class="mb-3">
                        <label for="vessel_department<?php echo e($vesselCert->id); ?>" class="form-label">Department</label>
                        <input type="text" class="form-control" id="vessel_department<?php echo e($vesselCert->id); ?>" name="vessel_department" value="<?php echo e($vesselCert->vessel_department); ?>">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="issued_date<?php echo e($vesselCert->id); ?>" class="form-label">Issued Date</label>
                                <input type="date" class="form-control" id="issued_date<?php echo e($vesselCert->id); ?>" name="issued_date" value="<?php echo e($vesselCert->issued_date ? $vesselCert->issued_date->format('Y-m-d') : ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="expiry_date<?php echo e($vesselCert->id); ?>" class="form-label">Expiry Date</label>
                                <input type="date" class="form-control" id="expiry_date<?php echo e($vesselCert->id); ?>" name="expiry_date" value="<?php echo e($vesselCert->expiry_date ? $vesselCert->expiry_date->format('Y-m-d') : ''); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="attachment<?php echo e($vesselCert->id); ?>" class="form-label">Add Attachments</label>
                        <input type="file" class="form-control" id="attachment<?php echo e($vesselCert->id); ?>" name="attachments[]" multiple>
                        <div class="form-text">You can select multiple files at once</div>
                    </div>

                    <?php if($vesselCert->attachment_path): ?>
                    <div class="mb-3">
                        <label class="form-label">Current Attachments:</label>
                        <?php
                            $attachments = json_decode($vesselCert->attachment_path, true);
                        ?>

                        <?php if(is_array($attachments)): ?>
                            <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-2 d-flex align-items-center">
                                    <?php
                                        $attachmentPath = $attachment;
                                    ?>
                                    <div class="btn-group me-2">
                                        <a href="<?php echo e(route('certificate.preview', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <a href="<?php echo e(route('certificate.file', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-primary">
                                            <i class="fas fa-download"></i> Download
                                        </a>
                                    </div>
                                    <form action="<?php echo e(url('/direct_delete_attachment.php')); ?>" method="POST" class="d-inline delete-attachment-form" onsubmit="return false;">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="vessel_certificate_id" value="<?php echo e($vesselCert->id); ?>">
                                        <input type="hidden" name="attachment_index" value="<?php echo e($index); ?>">
                                        <button type="button" class="btn btn-sm btn-danger simple-delete-btn"
                                                data-cert-id="<?php echo e($vesselCert->id); ?>"
                                                data-index="<?php echo e($index); ?>"
                                                data-attachment="<?php echo e($attachment); ?>">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <?php
                                $attachmentPath = $vesselCert->attachment_path;
                            ?>
                            <div class="d-flex align-items-center">
                                <div class="btn-group me-2">
                                    <a href="<?php echo e(route('certificate.preview', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                    <a href="<?php echo e(route('certificate.file', ['path' => $attachmentPath])); ?>" target="_blank" class="btn btn-sm btn-primary">
                                        <i class="fas fa-download"></i> Download
                                    </a>
                                </div>
                                <form action="<?php echo e(url('/direct_delete_attachment.php')); ?>" method="POST" class="d-inline delete-attachment-form" onsubmit="return false;">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="vessel_certificate_id" value="<?php echo e($vesselCert->id); ?>">
                                    <input type="hidden" name="attachment_index" value="0">
                                    <button type="button" class="btn btn-sm btn-danger simple-delete-btn"
                                            data-cert-id="<?php echo e($vesselCert->id); ?>"
                                            data-index="0"
                                            data-attachment="<?php echo e($attachmentPath); ?>">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </form>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary update-certificate-btn" data-id="<?php echo e($vesselCert->id); ?>">Update Certificate</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle certificate update button clicks
    const updateCertificateBtns = document.querySelectorAll('.update-certificate-btn');

    updateCertificateBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            const certId = btn.getAttribute('data-id');
            const form = document.getElementById('update-certificate-form-' + certId);

            if (!form) {
                console.error('Form not found for certificate ID: ' + certId);
                return;
            }

            // Show loading state
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Updating...';
            btn.disabled = true;

            // Create FormData from the form
            const formData = new FormData(form);

            // Check if there are files to upload
            const fileInput = form.querySelector('input[type="file"]');
            const hasFiles = fileInput && fileInput.files.length > 0;

            // If there are files, check their size
            if (hasFiles) {
                let totalSize = 0;
                for (let i = 0; i < fileInput.files.length; i++) {
                    totalSize += fileInput.files[i].size;
                }

                // If total size is too large, show warning and remove files from form data
                if (totalSize > 8 * 1024 * 1024) { // 8MB limit
                    if (!confirm('The total file size exceeds 8MB, which may cause errors. Do you want to continue without uploading files?')) {
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                        return;
                    }

                    // Remove files from form data
                    formData.delete('attachments[]');
                }
            }

            // Submit the form using fetch API
            fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (data && data.success) {
                    // Show success message without alert to avoid modal closing
                    const successMessage = document.createElement('div');
                    successMessage.className = 'alert alert-success mt-2';
                    successMessage.textContent = 'Certificate updated successfully!';
                    successMessage.id = 'certificate-update-success-' + certId;

                    // Find a good place to insert the message
                    const modalBody = form.querySelector('.modal-body');
                    if (modalBody) {
                        // Remove any existing messages
                        const existingMessages = modalBody.querySelectorAll('.alert');
                        existingMessages.forEach(msg => msg.remove());

                        // Insert at the top of the modal body
                        modalBody.insertBefore(successMessage, modalBody.firstChild);

                        // After 2 seconds, close the modal and reload the page
                        setTimeout(() => {
                            // Close the modal
                            const modal = form.closest('.modal');
                            const modalInstance = bootstrap.Modal.getInstance(modal);
                            if (modalInstance) {
                                modalInstance.hide();
                            }

                            // Reload the page
                            window.location.reload();
                        }, 2000);
                    } else {
                        // Fallback if modal body not found
                        alert('Certificate updated successfully!');

                        // Close the modal
                        const modal = form.closest('.modal');
                        const modalInstance = bootstrap.Modal.getInstance(modal);
                        if (modalInstance) {
                            modalInstance.hide();
                        }

                        // Reload the page
                        window.location.reload();
                    }
                } else if (data && data.error) {
                    // Show error message without alert
                    const errorMessage = document.createElement('div');
                    errorMessage.className = 'alert alert-danger mt-2';
                    errorMessage.textContent = 'Error: ' + data.error;
                    errorMessage.id = 'certificate-update-error-' + certId;

                    const modalBody = form.querySelector('.modal-body');
                    if (modalBody) {
                        // Remove any existing messages
                        const existingMessages = modalBody.querySelectorAll('.alert');
                        existingMessages.forEach(msg => msg.remove());

                        modalBody.insertBefore(errorMessage, modalBody.firstChild);
                    } else {
                        // Fallback if modal body not found
                        alert('Error: ' + data.error);
                    }
                } else {
                    // Show generic error message without alert
                    const errorMessage = document.createElement('div');
                    errorMessage.className = 'alert alert-danger mt-2';
                    errorMessage.textContent = 'Unknown error occurred. Please try again.';
                    errorMessage.id = 'certificate-update-error-generic-' + certId;

                    const modalBody = form.querySelector('.modal-body');
                    if (modalBody) {
                        // Remove any existing messages
                        const existingMessages = modalBody.querySelectorAll('.alert');
                        existingMessages.forEach(msg => msg.remove());

                        modalBody.insertBefore(errorMessage, modalBody.firstChild);
                    } else {
                        // Fallback if modal body not found
                        alert('Unknown error occurred. Please try again.');
                    }
                }
            })
            .catch(error => {
                console.error('Error:', error);

                // Show error message without alert to avoid modal closing
                const errorMessage = document.createElement('div');
                errorMessage.className = 'alert alert-danger mt-2';
                errorMessage.textContent = 'An error occurred while updating the certificate. This may be because the file is too large. Please try again with smaller files (less than 8MB total).';
                errorMessage.id = 'certificate-update-error-network-' + certId;

                const modalBody = form.querySelector('.modal-body');
                if (modalBody) {
                    // Remove any existing messages
                    const existingMessages = modalBody.querySelectorAll('.alert');
                    existingMessages.forEach(msg => msg.remove());

                    modalBody.insertBefore(errorMessage, modalBody.firstChild);
                } else {
                    // Fallback if modal body not found
                    alert('An error occurred while updating the certificate. This may be because the file is too large. Please try again with smaller files (less than 8MB total).');
                }
            })
            .finally(() => {
                // Reset button state
                btn.innerHTML = originalText;
                btn.disabled = false;
            });
        });
    });

    // Initialize selected count on page load
    updateSelectAllCheckbox();

    // Bulk download functionality
    document.getElementById('selectAll').addEventListener('click', function() {
        const checkboxes = document.querySelectorAll('.certificate-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = true;
        });
        updateSelectAllCheckbox();
    });

    document.getElementById('deselectAll').addEventListener('click', function() {
        const checkboxes = document.querySelectorAll('.certificate-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = false;
        });
        updateSelectAllCheckbox();
    });

    document.getElementById('selectAllCheckbox').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.certificate-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
    });

    // Update select all checkbox based on individual checkboxes
    function updateSelectAllCheckbox() {
        const checkboxes = document.querySelectorAll('.certificate-checkbox');
        const checkedBoxes = document.querySelectorAll('.certificate-checkbox:checked');
        const selectAllCheckbox = document.getElementById('selectAllCheckbox');
        const selectedCount = document.getElementById('selectedCount');

        // Update selected count
        selectedCount.textContent = `${checkedBoxes.length} selected`;

        if (checkedBoxes.length === 0) {
            selectAllCheckbox.checked = false;
            selectAllCheckbox.indeterminate = false;
        } else if (checkedBoxes.length === checkboxes.length) {
            selectAllCheckbox.checked = true;
            selectAllCheckbox.indeterminate = false;
        } else {
            selectAllCheckbox.checked = false;
            selectAllCheckbox.indeterminate = true;
        }
    }

    // Listen for changes on individual checkboxes
    document.addEventListener('change', function(e) {
        if (e.target.classList.contains('certificate-checkbox')) {
            updateSelectAllCheckbox();
        }
    });

    // Download selected certificates
    document.getElementById('downloadSelected').addEventListener('click', function(e) {
        e.preventDefault();

        const checkedBoxes = document.querySelectorAll('.certificate-checkbox:checked');
        if (checkedBoxes.length === 0) {
            alert('Please select at least one certificate to download.');
            return;
        }

        const certificateIds = Array.from(checkedBoxes).map(checkbox => checkbox.getAttribute('data-cert-id'));

        downloadCertificates(certificateIds, 'selected');
    });

    // Download by category
    document.querySelectorAll('.download-category').forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();

            const category = this.getAttribute('data-category');
            const categoryCheckboxes = document.querySelectorAll(`.certificate-checkbox[data-category="${category}"]`);

            if (categoryCheckboxes.length === 0) {
                alert('No certificates found in this category.');
                return;
            }

            const certificateIds = Array.from(categoryCheckboxes).map(checkbox => checkbox.getAttribute('data-cert-id'));

            downloadCertificates(certificateIds, 'category', category);
        });
    });

    function downloadCertificates(certificateIds, downloadType, category = null) {
        // Create a form to submit the download request
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?php echo e(route("vessel-certificates.bulk-download")); ?>';
        form.style.display = 'none';

        // Add CSRF token
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = '<?php echo e(csrf_token()); ?>';
        form.appendChild(csrfToken);

        // Add certificate IDs
        certificateIds.forEach(id => {
            const idInput = document.createElement('input');
            idInput.type = 'hidden';
            idInput.name = 'certificate_ids[]';
            idInput.value = id;
            form.appendChild(idInput);
        });

        // Add download type
        const typeInput = document.createElement('input');
        typeInput.type = 'hidden';
        typeInput.name = 'download_type';
        typeInput.value = downloadType;
        form.appendChild(typeInput);

        // Add vessel name
        const vesselNameInput = document.createElement('input');
        vesselNameInput.type = 'hidden';
        vesselNameInput.name = 'vessel_name';
        vesselNameInput.value = '<?php echo e($vessel->name); ?>';
        form.appendChild(vesselNameInput);

        // Add category if provided
        if (category) {
            const categoryInput = document.createElement('input');
            categoryInput.type = 'hidden';
            categoryInput.name = 'category';
            categoryInput.value = category;
            form.appendChild(categoryInput);
        }

        // Submit the form
        document.body.appendChild(form);
        form.submit();
        document.body.removeChild(form);
    }

    // Simple attachment deletion
    const simpleDeleteBtns = document.querySelectorAll('.simple-delete-btn');

    simpleDeleteBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            if (confirm('Are you sure you want to delete this attachment?')) {
                const certId = btn.getAttribute('data-cert-id');
                const attachmentIndex = btn.getAttribute('data-index');
                const attachmentPath = btn.getAttribute('data-attachment');

                // Show loading state
                const originalText = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                btn.disabled = true;

                // Create a simple form submission that will work even if session expires
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '<?php echo e(route("vessel-certificates.remove-attachment")); ?>';
                form.style.display = 'none';

                // Add CSRF token
                const csrfToken = document.createElement('input');
                csrfToken.type = 'hidden';
                csrfToken.name = '_token';
                csrfToken.value = '<?php echo e(csrf_token()); ?>';
                form.appendChild(csrfToken);

                // Add certificate ID
                const certIdField = document.createElement('input');
                certIdField.type = 'hidden';
                certIdField.name = 'vessel_certificate_id';
                certIdField.value = certId;
                form.appendChild(certIdField);

                // Add attachment index
                const indexField = document.createElement('input');
                indexField.type = 'hidden';
                indexField.name = 'attachment_index';
                indexField.value = attachmentIndex;
                form.appendChild(indexField);

                // Add attachment path
                const pathField = document.createElement('input');
                pathField.type = 'hidden';
                pathField.name = 'attachment_path';
                pathField.value = attachmentPath;
                form.appendChild(pathField);

                // Show a message to the user
                const attachmentElement = btn.closest('.mb-2') || btn.closest('.d-flex');
                if (attachmentElement) {
                    const message = document.createElement('div');
                    message.className = 'alert alert-info mt-2';
                    message.textContent = 'Deleting attachment...';
                    attachmentElement.appendChild(message);
                }

                // Add the form to the document and submit it
                document.body.appendChild(form);
                form.submit();
            }
        });
    });

    // Handle attachment deletion
    const deleteAttachmentBtns = document.querySelectorAll('.delete-attachment-btn');

    deleteAttachmentBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            if (confirm('Are you sure you want to delete this attachment?')) {
                const form = btn.closest('form');
                const certId = btn.getAttribute('data-cert-id');
                const attachmentIndex = btn.getAttribute('data-index');

                if (!form) {
                    console.error('Form not found for delete attachment button');
                    return;
                }

                // Show loading state
                const originalText = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                btn.disabled = true;

                // Create FormData from the form
                const formData = new FormData(form);

                // Submit the form using fetch API to our direct script
                fetch(form.action, {
                    method: 'POST',
                    body: formData
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.text();
                })
                .then(responseText => {
                    console.log('Raw response:', responseText);

                    // Initialize jsonData variable first
                    let jsonData = null;

                    // Check if the response is HTML (likely a login page)
                    if (responseText.trim().startsWith('<!DOCTYPE html>') ||
                        responseText.trim().startsWith('<html')) {
                        console.error('Received HTML response instead of JSON. Session may have expired.');

                        // Create a simulated JSON response
                        jsonData = {
                            success: false,
                            message: 'Your session may have expired. Please refresh the page and try again.',
                            logs: ['Received HTML response instead of JSON']
                        };

                        // Optionally, you could reload the page
                        // setTimeout(() => window.location.reload(), 3000);
                    } else {
                        // Try to parse the JSON response
                        try {
                            jsonData = JSON.parse(responseText);
                        } catch (e) {
                            console.error('Error parsing JSON:', e);

                            // As a fallback, try to extract JSON from the response text
                            try {
                                // Find the last occurrence of '{' and parse from there
                                const jsonStart = responseText.lastIndexOf('{');
                                if (jsonStart !== -1) {
                                    const jsonStr = responseText.substring(jsonStart);
                                    jsonData = JSON.parse(jsonStr);
                                } else {
                                    // If no JSON found, create a simulated response
                                    jsonData = {
                                        success: false,
                                        message: 'Invalid response from server. Please try again.',
                                        logs: ['Failed to parse response: ' + responseText.substring(0, 100) + '...']
                                    };
                                }
                            } catch (e2) {
                                console.error('Second error parsing JSON:', e2);

                                // Create a simulated JSON response
                                jsonData = {
                                    success: false,
                                    message: 'Failed to process server response. Please try again.',
                                    logs: ['Failed to parse response', responseText.substring(0, 100) + '...']
                                };
                            }
                        }
                    }

                    if (jsonData && jsonData.success) {
                        console.log('Attachment deleted successfully:', jsonData);

                        // Force a hard delete by making a second request
                        // This is a backup to ensure the file is really deleted
                        fetch(form.action, {
                            method: 'POST',
                            body: formData
                        }).catch(e => console.log('Second delete attempt:', e));

                        // Remove the attachment element from the DOM
                        const attachmentElement = btn.closest('.mb-2') || btn.closest('.d-flex');
                        if (attachmentElement) {
                            attachmentElement.remove();
                        }

                        // Show success message without alert to avoid modal closing
                        const successMessage = document.createElement('div');
                        successMessage.className = 'alert alert-success mt-2';
                        successMessage.textContent = 'Attachment deleted successfully! The file has been permanently removed.';
                        successMessage.id = 'attachment-delete-success-' + certId + '-' + attachmentIndex;

                        // Add debug info in a hidden div
                        const debugInfo = document.createElement('div');
                        debugInfo.style.display = 'none';

                        // If we have logs, display them
                        if (jsonData.logs && Array.isArray(jsonData.logs)) {
                            debugInfo.innerHTML = '<pre>' + jsonData.logs.join('\n') + '</pre>';
                        } else {
                            debugInfo.innerHTML = '<pre>' + responseText + '</pre>';
                        }

                        // Add a button to show/hide debug info
                        const debugButton = document.createElement('button');
                        debugButton.className = 'btn btn-sm btn-link';
                        debugButton.textContent = 'Show Debug Info';
                        debugButton.onclick = function(e) {
                            e.preventDefault();
                            if (debugInfo.style.display === 'none') {
                                debugInfo.style.display = 'block';
                                this.textContent = 'Hide Debug Info';
                            } else {
                                debugInfo.style.display = 'none';
                                this.textContent = 'Show Debug Info';
                            }
                        };

                        successMessage.appendChild(debugButton);
                        successMessage.appendChild(debugInfo);

                        // Find a good place to insert the message
                        const modalBody = btn.closest('.modal-body');
                        if (modalBody) {
                            // Remove any existing success messages
                            const existingMessages = modalBody.querySelectorAll('.alert');
                            existingMessages.forEach(msg => msg.remove());

                            // Insert at the top of the modal body
                            modalBody.insertBefore(successMessage, modalBody.firstChild);

                            // Auto-remove the message after 5 seconds
                            setTimeout(() => {
                                const msgElement = document.getElementById('attachment-delete-success-' + certId + '-' + attachmentIndex);
                                if (msgElement) {
                                    msgElement.remove();
                                }
                            }, 5000);
                        }
                    } else if (jsonData && jsonData.message) {
                        // Show error message without alert
                        const errorMessage = document.createElement('div');
                        errorMessage.className = 'alert alert-danger mt-2';
                        errorMessage.textContent = jsonData.message;
                        errorMessage.id = 'attachment-delete-error-' + certId + '-' + attachmentIndex;

                        // Add debug info in a hidden div
                        const debugInfo = document.createElement('div');
                        debugInfo.style.display = 'none';

                        // If we have logs, display them
                        if (jsonData.logs && Array.isArray(jsonData.logs)) {
                            debugInfo.innerHTML = '<pre>' + jsonData.logs.join('\n') + '</pre>';
                        } else {
                            debugInfo.innerHTML = '<pre>' + responseText + '</pre>';
                        }

                        // Add a button to show/hide debug info
                        const debugButton = document.createElement('button');
                        debugButton.className = 'btn btn-sm btn-link';
                        debugButton.textContent = 'Show Debug Info';
                        debugButton.onclick = function(e) {
                            e.preventDefault();
                            if (debugInfo.style.display === 'none') {
                                debugInfo.style.display = 'block';
                                this.textContent = 'Hide Debug Info';
                            } else {
                                debugInfo.style.display = 'none';
                                this.textContent = 'Show Debug Info';
                            }
                        };

                        errorMessage.appendChild(debugButton);
                        errorMessage.appendChild(debugInfo);

                        const modalBody = btn.closest('.modal-body');
                        if (modalBody) {
                            // Remove any existing error messages
                            const existingMessages = modalBody.querySelectorAll('.alert');
                            existingMessages.forEach(msg => msg.remove());

                            modalBody.insertBefore(errorMessage, modalBody.firstChild);
                            setTimeout(() => {
                                const msgElement = document.getElementById('attachment-delete-error-' + certId + '-' + attachmentIndex);
                                if (msgElement) {
                                    msgElement.remove();
                                }
                            }, 3000);
                        }
                    } else {
                        // Show generic error message without alert
                        const errorMessage = document.createElement('div');
                        errorMessage.className = 'alert alert-danger mt-2';
                        errorMessage.textContent = 'Unknown error occurred. Please try again.';
                        errorMessage.id = 'attachment-delete-error-generic-' + certId + '-' + attachmentIndex;

                        // Add debug info in a hidden div
                        const debugInfo = document.createElement('div');
                        debugInfo.style.display = 'none';

                        // If we have logs, display them
                        if (jsonData && jsonData.logs && Array.isArray(jsonData.logs)) {
                            debugInfo.innerHTML = '<pre>' + jsonData.logs.join('\n') + '</pre>';
                        } else {
                            debugInfo.innerHTML = '<pre>' + responseText + '</pre>';
                        }

                        // Add a button to show/hide debug info
                        const debugButton = document.createElement('button');
                        debugButton.className = 'btn btn-sm btn-link';
                        debugButton.textContent = 'Show Debug Info';
                        debugButton.onclick = function(e) {
                            e.preventDefault();
                            if (debugInfo.style.display === 'none') {
                                debugInfo.style.display = 'block';
                                this.textContent = 'Hide Debug Info';
                            } else {
                                debugInfo.style.display = 'none';
                                this.textContent = 'Show Debug Info';
                            }
                        };

                        errorMessage.appendChild(debugButton);
                        errorMessage.appendChild(debugInfo);

                        const modalBody = btn.closest('.modal-body');
                        if (modalBody) {
                            // Remove any existing error messages
                            const existingMessages = modalBody.querySelectorAll('.alert');
                            existingMessages.forEach(msg => msg.remove());

                            modalBody.insertBefore(errorMessage, modalBody.firstChild);
                            setTimeout(() => {
                                const msgElement = document.getElementById('attachment-delete-error-generic-' + certId + '-' + attachmentIndex);
                                if (msgElement) {
                                    msgElement.remove();
                                }
                            }, 3000);
                        }
                    }
                })
                .catch(error => {
                    console.error('Error deleting attachment:', error);

                    // Show error message without alert to avoid modal closing
                    const errorMessage = document.createElement('div');
                    errorMessage.className = 'alert alert-danger mt-2';
                    errorMessage.textContent = 'An error occurred while deleting the attachment. Please try again.';
                    errorMessage.id = 'attachment-delete-error-network-' + certId + '-' + attachmentIndex;

                    const modalBody = btn.closest('.modal-body');
                    if (modalBody) {
                        // Remove any existing error messages
                        const existingMessages = modalBody.querySelectorAll('.alert');
                        existingMessages.forEach(msg => msg.remove());

                        modalBody.insertBefore(errorMessage, modalBody.firstChild);
                        setTimeout(() => {
                            const msgElement = document.getElementById('attachment-delete-error-network-' + certId + '-' + attachmentIndex);
                            if (msgElement) {
                                msgElement.remove();
                            }
                        }, 5000);
                    }

                    // Try a second time with a different approach
                    setTimeout(() => {
                        console.log('Attempting second deletion method...');
                        fetch('<?php echo e(url('/direct_delete_attachment.php')); ?>', {
                            method: 'POST',
                            body: formData
                        }).catch(e => console.log('Second error attempt:', e));
                    }, 1000);
                })
                .finally(() => {
                    // Reset button state
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                });
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ibrahimbchara/Downloads/certificates/vessel-certificates/resources/views/vessels/show.blade.php ENDPATH**/ ?>