<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RecordAttachment extends Model
{
    protected $fillable = [
        'record_id',
        'file_name',
        'file_path'
    ];

    public function record(): BelongsTo
    {
        return $this->belongsTo(VesselRecord::class, 'record_id');
    }
}
