<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = [
        'setting_name',
        'setting_value'
    ];

    public static function getValue(string $name, $default = null)
    {
        $setting = static::where('setting_name', $name)->first();
        return $setting ? $setting->setting_value : $default;
    }

    public static function setValue(string $name, $value): void
    {
        static::updateOrCreate(
            ['setting_name' => $name],
            ['setting_value' => $value]
        );
    }
}
