<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class StatusOption extends Model
{
    protected $fillable = [
        'name',
        'color',
        'is_paid_status'
    ];

    protected $casts = [
        'is_paid_status' => 'boolean'
    ];

    public function records(): HasMany
    {
        return $this->hasMany(VesselRecord::class, 'status_id');
    }
}
