<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vessel_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vessel_id')->nullable()->constrained('vessels')->onDelete('cascade');
            $table->date('date')->nullable();
            $table->string('invoice_no', 50)->nullable();
            $table->string('port', 100)->nullable();
            $table->text('description')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->date('due_date')->nullable();
            $table->string('company', 100)->nullable();
            $table->foreignId('status_id')->nullable()->constrained('status_options')->onDelete('set null');
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vessel_records');
    }
};
