<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Vessel;
use App\Models\StatusOption;
use App\Models\VesselRecord;
use App\Models\RecordAttachment;
use App\Models\Setting;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class BunkerDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Import users exactly from SQL
        DB::table('users')->insert([
            'name' => 'bunker', // Using username as name since Laravel requires name field
            'email' => 'admin@example.com',
            'password' => '$2y$10$YN8v35Y8l9AG7eoHT2n7QOQVG3OcNpRNTd5U/PYvUUI0XqG/qpjP.',
            'is_admin' => 1,
            'created_at' => '2024-11-20 10:38:12',
            'updated_at' => '2024-11-20 10:38:12',
        ]);

        // Import settings exactly from SQL
        DB::table('settings')->insert([
            ['id' => 1, 'setting_name' => 'warning_days', 'setting_value' => '8', 'created_at' => '2024-11-20 10:43:36'],
            ['id' => 2, 'setting_name' => 'critical_days', 'setting_value' => '5', 'created_at' => '2024-11-20 10:43:36'],
        ]);

        // Import status options exactly from SQL
        DB::table('status_options')->insert([
            ['id' => 7, 'name' => 'Confirmed', 'color' => '#000000', 'created_at' => '2025-01-06 11:35:06', 'is_paid_status' => 0],
            ['id' => 8, 'name' => 'Paid By Hamza', 'color' => '#000000', 'created_at' => '2025-01-06 11:35:11', 'is_paid_status' => 1],
            ['id' => 9, 'name' => 'UNPAID', 'color' => '#000000', 'created_at' => '2025-01-06 11:35:19', 'is_paid_status' => 0],
            ['id' => 10, 'name' => 'Paid By Jamil', 'color' => '#000000', 'created_at' => '2025-01-30 08:42:48', 'is_paid_status' => 1],
        ]);

        // Import vessels exactly from SQL
        DB::table('vessels')->insert([
            ['id' => 6, 'name' => 'PARESA', 'created_by' => null, 'created_at' => '2024-11-21 05:08:27', 'updated_at' => '2024-11-21 05:08:27'],
            ['id' => 7, 'name' => 'AK BRIGHT', 'created_by' => null, 'created_at' => '2024-11-21 07:04:57', 'updated_at' => '2024-11-21 07:04:57'],
            ['id' => 8, 'name' => 'AK BEAUTY', 'created_by' => null, 'created_at' => '2025-01-06 11:33:41', 'updated_at' => '2025-01-06 11:33:41'],
            ['id' => 9, 'name' => 'SUAVE', 'created_by' => null, 'created_at' => '2025-01-07 06:25:46', 'updated_at' => '2025-01-07 06:25:46'],
            ['id' => 11, 'name' => 'AK BROTHERS', 'created_by' => null, 'created_at' => '2025-01-07 06:26:03', 'updated_at' => '2025-01-07 06:26:03'],
            ['id' => 12, 'name' => 'AK LIZA', 'created_by' => null, 'created_at' => '2025-01-07 06:28:55', 'updated_at' => '2025-01-07 06:28:55'],
            ['id' => 13, 'name' => 'AK GARY', 'created_by' => null, 'created_at' => '2025-01-07 06:32:32', 'updated_at' => '2025-01-07 06:32:32'],
            ['id' => 14, 'name' => 'AK KHAIRA', 'created_by' => null, 'created_at' => '2025-01-09 06:45:06', 'updated_at' => '2025-01-09 06:45:06'],
            ['id' => 15, 'name' => 'AK AMBITION', 'created_by' => null, 'created_at' => '2025-01-14 07:37:19', 'updated_at' => '2025-01-14 07:37:19'],
            ['id' => 16, 'name' => 'AK HALIMA', 'created_by' => null, 'created_at' => '2025-01-15 06:42:03', 'updated_at' => '2025-01-15 06:42:03'],
            ['id' => 17, 'name' => 'AK DISCOVERY', 'created_by' => null, 'created_at' => '2025-01-22 11:02:16', 'updated_at' => '2025-01-22 11:02:16'],
            ['id' => 18, 'name' => 'AK KHADEJA', 'created_by' => null, 'created_at' => '2025-01-22 11:04:09', 'updated_at' => '2025-01-22 11:04:09'],
            ['id' => 19, 'name' => 'AK HAMZA', 'created_by' => null, 'created_at' => '2025-01-24 09:44:20', 'updated_at' => '2025-01-24 09:44:20'],
            ['id' => 20, 'name' => 'MAYMONA', 'created_by' => null, 'created_at' => '2025-01-30 08:20:53', 'updated_at' => '2025-01-30 08:20:53'],
            ['id' => 21, 'name' => 'AK GLORIOUS', 'created_by' => null, 'created_at' => '2025-02-04 07:50:34', 'updated_at' => '2025-02-04 07:50:34'],
            ['id' => 22, 'name' => 'AK CARL', 'created_by' => null, 'created_at' => '2025-03-03 06:31:42', 'updated_at' => '2025-03-03 06:31:42'],
        ]);

        // Import vessel records - Part 1
        $this->importVesselRecordsPart1();

        // Import vessel records - Part 2
        $this->importVesselRecordsPart2();

        // Import vessel records - Part 3
        $this->importVesselRecordsPart3();

        // Import record attachments
        $this->importRecordAttachments();
    }

    private function importVesselRecordsPart1()
    {
        // Import vessel records exactly from SQL - Part 1 (records 66-100)
        $records = [
            ['id' => 66, 'vessel_id' => 9, 'date' => '2025-01-10', 'invoice_no' => '00045', 'port' => 'San Nicolas', 'description' => '27 MTS MGO*781+ 4000 L.OIL *1.97+ 1 DRUM OIL 15W40 *450', 'amount' => 30382.00, 'due_date' => '2025-02-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-07 06:28:37', 'updated_at' => '2025-01-07 06:28:37'],
            ['id' => 67, 'vessel_id' => 12, 'date' => '2025-01-11', 'invoice_no' => '00062', 'port' => 'ALGIERS', 'description' => '200.74 VLSFO *567 + 69 MTS MGO *747 +25 EXTRA MGO *765', 'amount' => 189219.00, 'due_date' => '2025-02-11', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-07 06:30:48', 'updated_at' => '2025-01-07 06:30:48'],
            ['id' => 68, 'vessel_id' => 13, 'date' => '2025-01-07', 'invoice_no' => '00039', 'port' => 'Tripoli', 'description' => '200 MTS VLSFO*530 +30 MTS MGO *745', 'amount' => 129077.00, 'due_date' => '2025-01-26', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-07 06:39:03', 'updated_at' => '2025-01-07 06:39:03'],
            ['id' => 69, 'vessel_id' => 11, 'date' => '2025-01-11', 'invoice_no' => '00035', 'port' => 'Abu Qir', 'description' => '3000 L L.OIL *2.15', 'amount' => 7150.00, 'due_date' => '2025-02-11', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-08 06:52:29', 'updated_at' => '2025-01-08 06:52:29'],
            ['id' => 70, 'vessel_id' => 14, 'date' => '2025-01-09', 'invoice_no' => '00041', 'port' => 'Misurata', 'description' => '200 VLSFO * 530 $+20 MTS MGO *745 + CTM 5000 ', 'amount' => 125900.00, 'due_date' => '2025-01-27', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-09 06:47:44', 'updated_at' => '2025-01-09 06:47:44'],
            ['id' => 72, 'vessel_id' => 13, 'date' => '2025-01-07', 'invoice_no' => '00038', 'port' => 'Tripoli', 'description' => '38 drums *600 +3 pails *75 l.oil', 'amount' => 23550.00, 'due_date' => '2025-02-05', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-14 07:24:37', 'updated_at' => '2025-01-14 07:24:37'],
            ['id' => 73, 'vessel_id' => 15, 'date' => '2025-01-13', 'invoice_no' => '00061', 'port' => 'Arzew', 'description' => '115 VLSFO*585 + 35 MGO *763', 'amount' => 97279.58, 'due_date' => '2025-02-13', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-14 07:39:38', 'updated_at' => '2025-01-14 07:39:38'],
            ['id' => 76, 'vessel_id' => 16, 'date' => '2025-01-14', 'invoice_no' => '00063', 'port' => 'Gdansk', 'description' => '30 MTS MGO*818', 'amount' => 24540.00, 'due_date' => '2025-02-15', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-15 06:43:00', 'updated_at' => '2025-01-15 06:43:00'],
            ['id' => 77, 'vessel_id' => 8, 'date' => '2025-01-20', 'invoice_no' => '00083', 'port' => 'Tuzla', 'description' => '2912 L OIL *3.55 +350 TRANSPORTATION', 'amount' => 10687.60, 'due_date' => '2025-02-19', 'company' => 'enzo', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-20 08:48:34', 'updated_at' => '2025-01-20 08:48:34'],
            ['id' => 78, 'vessel_id' => 8, 'date' => '2025-01-25', 'invoice_no' => '00091', 'port' => 'ISTANBUL', 'description' => '200 vlsfo * 650 + 30 mts MGO *795', 'amount' => 156350.00, 'due_date' => '2025-02-25', 'company' => 'enzo', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-22 08:00:57', 'updated_at' => '2025-01-22 08:00:57'],
            ['id' => 79, 'vessel_id' => 17, 'date' => '2025-01-22', 'invoice_no' => '00088', 'port' => 'Tripoli', 'description' => '30 MTS MGO *797+ 2000 CTM ', 'amount' => 25910.00, 'due_date' => '2025-02-22', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-22 11:03:25', 'updated_at' => '2025-01-22 11:03:25'],
            ['id' => 80, 'vessel_id' => 18, 'date' => '2025-01-22', 'invoice_no' => '00086', 'port' => 'Cartagena - Spain', 'description' => '54 MTS MGO *798', 'amount' => 42227.77, 'due_date' => '2025-02-22', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-22 11:05:33', 'updated_at' => '2025-01-22 11:05:33'],
            ['id' => 81, 'vessel_id' => 19, 'date' => '2025-01-26', 'invoice_no' => '2292', 'port' => 'GDANSK', 'description' => '60 MTS MGO *790', 'amount' => 47400.00, 'due_date' => '2025-02-26', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-24 09:45:10', 'updated_at' => '2025-01-24 09:45:10'],
            ['id' => 82, 'vessel_id' => 19, 'date' => '2025-01-28', 'invoice_no' => '02300', 'port' => 'Gdansk', 'description' => '1000 l oil shell s30*2.15+ 2000 L SHELL 40 *2.32', 'amount' => 7040.00, 'due_date' => '2025-02-28', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-28 08:39:30', 'updated_at' => '2025-01-28 08:39:30'],
            ['id' => 84, 'vessel_id' => 20, 'date' => '2025-01-31', 'invoice_no' => '02298', 'port' => 'Durres', 'description' => 'MGO 75 *790 USD', 'amount' => 59249.21, 'due_date' => '2025-03-01', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-30 08:22:10', 'updated_at' => '2025-01-30 08:22:10'],
            ['id' => 85, 'vessel_id' => 17, 'date' => '2025-01-29', 'invoice_no' => '02299', 'port' => 'SAN NIKOLAS', 'description' => '5000 L *2 ', 'amount' => 2299.00, 'due_date' => '2025-02-28', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-30 08:40:17', 'updated_at' => '2025-01-30 08:40:17'],
            ['id' => 86, 'vessel_id' => 12, 'date' => '2025-02-13', 'invoice_no' => '2375', 'port' => 'Gdansk', 'description' => '100 MTS MGO*777+ 3000L L.OIL*2.32', 'amount' => 65616.51, 'due_date' => '2025-03-15', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-01-31 10:07:01', 'updated_at' => '2025-01-31 10:07:01'],
            ['id' => 89, 'vessel_id' => 17, 'date' => '2025-02-08', 'invoice_no' => '2335', 'port' => 'Algiers', 'description' => 'VLSFO 120.010 *582 +MGO 15.050 MTS*785', 'amount' => 83884.19, 'due_date' => '2025-03-10', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-04 07:50:16', 'updated_at' => '2025-02-04 07:50:16'],
            ['id' => 90, 'vessel_id' => 21, 'date' => '2025-02-06', 'invoice_no' => '02336', 'port' => 'Algiers', 'description' => 'VLSFO 100 MTS *582+ MGO 90 MTS *785', 'amount' => 131185.99, 'due_date' => '2025-03-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-04 07:53:42', 'updated_at' => '2025-02-04 07:53:42'],
            ['id' => 91, 'vessel_id' => 7, 'date' => '2025-02-05', 'invoice_no' => '02329', 'port' => 'Misurata', 'description' => 'MGO 70 MTS*755 ', 'amount' => 52850.00, 'due_date' => '2025-03-05', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-04 09:45:05', 'updated_at' => '2025-02-04 09:45:05'],
            ['id' => 92, 'vessel_id' => 16, 'date' => '2025-02-04', 'invoice_no' => '02322', 'port' => 'Arzew', 'description' => 'VLSFO 300.495 * 582 USD', 'amount' => 178103.02, 'due_date' => '2025-03-04', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-06 08:17:47', 'updated_at' => '2025-02-06 08:17:47'],
            ['id' => 94, 'vessel_id' => 9, 'date' => '2025-02-06', 'invoice_no' => '02371', 'port' => 'Dunkirk', 'description' => 'MGO 40.062 MTS*815 USD', 'amount' => 32650.53, 'due_date' => '2025-03-15', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-06 08:28:15', 'updated_at' => '2025-02-06 08:28:15'],
            ['id' => 95, 'vessel_id' => 20, 'date' => '2025-02-11', 'invoice_no' => '02407', 'port' => 'Vassiliko', 'description' => '3000 oil * 2.68 usd', 'amount' => 8840.00, 'due_date' => '2025-03-11', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-11 09:27:50', 'updated_at' => '2025-02-11 09:27:50'],
            ['id' => 96, 'vessel_id' => 19, 'date' => '2025-02-15', 'invoice_no' => '02376', 'port' => 'Algiers', 'description' => 'VLSFO 120.480 MTS*564 USD + MGO 50.398 MTS*746 USD', 'amount' => 107775.98, 'due_date' => '2025-03-15', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-17 10:42:07', 'updated_at' => '2025-02-17 10:42:07'],
            ['id' => 97, 'vessel_id' => 18, 'date' => '2025-02-17', 'invoice_no' => '2363', 'port' => 'Nemrut Bay', 'description' => 'MGO 30 MTS *865 USD', 'amount' => 43250.00, 'due_date' => '2025-03-17', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-17 10:43:42', 'updated_at' => '2025-02-17 10:43:42'],
            ['id' => 98, 'vessel_id' => 11, 'date' => '2025-02-14', 'invoice_no' => '02372', 'port' => 'ISTANBUL', 'description' => 'MGO 100 MTS *760 USD', 'amount' => 77500.00, 'due_date' => '2025-03-15', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-18 12:04:48', 'updated_at' => '2025-02-18 12:04:48'],
            ['id' => 100, 'vessel_id' => 14, 'date' => '2025-02-19', 'invoice_no' => '02381', 'port' => 'ISTANBUL', 'description' => 'OIL 11000 L *2.2 USD paid ak halima gdansk 00063', 'amount' => 24230.00, 'due_date' => '2025-03-19', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-19 10:49:09', 'updated_at' => '2025-02-19 10:49:09'],
        ];

        DB::table('vessel_records')->insert($records);
    }

    private function importVesselRecordsPart2()
    {
        // Import vessel records exactly from SQL - Part 2 (records 101-150)
        $records = [
            ['id' => 101, 'vessel_id' => 17, 'date' => '2025-02-18', 'invoice_no' => '02412', 'port' => 'Dunkirk', 'description' => 'MGO 20 MTS *835 USD', 'amount' => 16779.00, 'due_date' => '2025-03-18', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-19 10:52:12', 'updated_at' => '2025-02-19 10:52:12'],
            ['id' => 102, 'vessel_id' => 17, 'date' => '2025-02-22', 'invoice_no' => '2416', 'port' => 'Hamburg', 'description' => 'MGO 20 MTS *780 USD ', 'amount' => 16028.54, 'due_date' => '2025-03-24', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-24 08:13:37', 'updated_at' => '2025-02-24 08:13:37'],
            ['id' => 103, 'vessel_id' => 12, 'date' => '2025-02-26', 'invoice_no' => '02426', 'port' => 'Gdansk', 'description' => 'MGO 70 MTS*770 USD', 'amount' => 53900.00, 'due_date' => '2025-03-31', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-26 10:36:51', 'updated_at' => '2025-02-26 10:36:51'],
            ['id' => 105, 'vessel_id' => 15, 'date' => '2025-03-06', 'invoice_no' => '02505', 'port' => 'Algiers', 'description' => 'VLSFO 100 MTS* 560 USD+ MGO 38 MTS *746 USD', 'amount' => 97319.39, 'due_date' => '2025-04-05', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-02-26 10:40:18', 'updated_at' => '2025-02-26 10:40:18'],
            ['id' => 106, 'vessel_id' => 6, 'date' => '2025-03-01', 'invoice_no' => '2489', 'port' => 'Iskenderun', 'description' => 'MGO 26 MTS *795 USD + OIL 6000L*2022+ 416L *3.75', 'amount' => 37613.64, 'due_date' => '2025-04-05', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-03 06:29:41', 'updated_at' => '2025-03-03 06:29:41'],
            ['id' => 107, 'vessel_id' => 22, 'date' => '2025-03-02', 'invoice_no' => '02423', 'port' => 'ISTANBUL', 'description' => 'VLSFO 70 MTS *590 USD + 8000 L OIL *2.2 USD ', 'amount' => 61500.00, 'due_date' => '2025-04-03', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-03 06:34:30', 'updated_at' => '2025-03-03 06:34:30'],
            ['id' => 108, 'vessel_id' => 21, 'date' => '2025-03-12', 'invoice_no' => '02465', 'port' => 'Gdansk', 'description' => 'MGO 70 MTS *715 + OIL 3000 L *2.32 USD ', 'amount' => 57010.00, 'due_date' => '2025-04-10', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-13 06:30:56', 'updated_at' => '2025-03-13 06:30:56'],
            ['id' => 109, 'vessel_id' => 19, 'date' => '2025-03-06', 'invoice_no' => '02445', 'port' => 'Abu Qir', 'description' => 'l.oil 3000 l *1.98 usd ', 'amount' => 6890.00, 'due_date' => '2025-04-05', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-13 06:34:22', 'updated_at' => '2025-03-13 06:34:22'],
            ['id' => 110, 'vessel_id' => 18, 'date' => '2025-03-12', 'invoice_no' => '2477', 'port' => 'Vassaliko', 'description' => 'MGO 50 MTS * 835 USD ', 'amount' => 42075.65, 'due_date' => '2025-04-11', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-13 06:36:14', 'updated_at' => '2025-03-13 06:36:14'],
            ['id' => 111, 'vessel_id' => 6, 'date' => '2025-03-14', 'invoice_no' => '2570', 'port' => 'ISTANBUL', 'description' => 'VLSFO 50 mts * 556 + MGO 30 * 712 usd', 'amount' => 31700.00, 'due_date' => '2025-04-13', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-13 06:40:17', 'updated_at' => '2025-03-13 06:40:17'],
            ['id' => 112, 'vessel_id' => 14, 'date' => '2025-03-15', 'invoice_no' => '02496 ', 'port' => 'Port Zarkis', 'description' => 'OIL 5 DRUMS * 760 USD + OIL 4 PAILS *178 USD', 'amount' => 4712.00, 'due_date' => '2025-04-14', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-14 09:14:51', 'updated_at' => '2025-03-14 09:14:51'],
            ['id' => 113, 'vessel_id' => 8, 'date' => '2025-03-17', 'invoice_no' => '2502', 'port' => 'SKIKDA', 'description' => 'MGO 22 MTS* 710', 'amount' => 16239.27, 'due_date' => '2025-04-17', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-17 08:48:56', 'updated_at' => '2025-03-17 08:48:56'],
            ['id' => 114, 'vessel_id' => 17, 'date' => '2025-03-19', 'invoice_no' => '02536', 'port' => 'Algiers', 'description' => 'VLSFO 150 MTS*519 + MGO 30 MTS * 709 ', 'amount' => 109748.13, 'due_date' => '2025-04-20', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-17 08:50:38', 'updated_at' => '2025-03-17 08:50:38'],
            ['id' => 115, 'vessel_id' => 14, 'date' => '2025-03-18', 'invoice_no' => '2534', 'port' => 'Zarzis', 'description' => 'MGO 53.21 *769 USD ', 'amount' => 40932.33, 'due_date' => '2025-04-17', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-18 07:50:56', 'updated_at' => '2025-03-18 07:50:56'],
            ['id' => 116, 'vessel_id' => 14, 'date' => '2025-03-27', 'invoice_no' => '2585', 'port' => 'Gibraltar ', 'description' => 'VLSFO 100 *535 USD + MGO 10 *720', 'amount' => 64929.33, 'due_date' => '2025-04-26', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-20 08:52:46', 'updated_at' => '2025-03-20 08:52:46'],
            ['id' => 117, 'vessel_id' => 22, 'date' => '2025-03-26', 'invoice_no' => '2578', 'port' => 'Malta', 'description' => 'VLSFO 300 MTS *518 USD', 'amount' => 158400.00, 'due_date' => '2025-05-03', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-27 08:14:44', 'updated_at' => '2025-03-27 08:14:44'],
            ['id' => 119, 'vessel_id' => 16, 'date' => '2025-03-26', 'invoice_no' => '2572', 'port' => 'Algiers', 'description' => 'VLSFO 150 *522 + MGO 160* 710', 'amount' => 194377.51, 'due_date' => '2025-05-02', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-27 08:18:32', 'updated_at' => '2025-03-27 08:18:32'],
            ['id' => 120, 'vessel_id' => 21, 'date' => '2025-03-26', 'invoice_no' => '2573', 'port' => 'Oran', 'description' => 'VLSFO 130 * 522 + MGO 50* 710 ', 'amount' => 105688.45, 'due_date' => '2025-04-30', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-03-27 11:31:59', 'updated_at' => '2025-03-27 11:31:59'],
            ['id' => 121, 'vessel_id' => 15, 'date' => '2025-03-31', 'invoice_no' => '2565', 'port' => 'Lisbon', 'description' => 'MGO 27 MTS* 762 USD', 'amount' => 20631.15, 'due_date' => '2025-04-30', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-02 08:28:59', 'updated_at' => '2025-04-02 08:28:59'],
            ['id' => 122, 'vessel_id' => 20, 'date' => '2025-04-03', 'invoice_no' => '2589', 'port' => 'ISTANBUL', 'description' => 'MGO 50 MTS *750 USD', 'amount' => 39000.00, 'due_date' => '2025-05-06', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-02 11:03:04', 'updated_at' => '2025-04-02 11:03:04'],
            ['id' => 123, 'vessel_id' => 7, 'date' => '2025-04-07', 'invoice_no' => '2600', 'port' => 'Durres', 'description' => 'MGO 30 MTS *687 USD', 'amount' => 21343.72, 'due_date' => '2025-05-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-09 07:16:23', 'updated_at' => '2025-04-09 07:16:23'],
            ['id' => 124, 'vessel_id' => 13, 'date' => '2025-04-01', 'invoice_no' => '2602', 'port' => 'Misurata', 'description' => 'VLSFO 200*494.11 USD', 'amount' => 106114.50, 'due_date' => '2025-05-05', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-09 07:20:58', 'updated_at' => '2025-04-09 07:20:58'],
            ['id' => 125, 'vessel_id' => 19, 'date' => '2025-04-08', 'invoice_no' => '2614', 'port' => 'Gdansk', 'description' => 'MGO 40* 656 USD + shell alexia 40/3000 L * 2.33 USD', 'amount' => 33230.00, 'due_date' => '2025-05-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-09 07:24:38', 'updated_at' => '2025-04-09 07:24:38'],
            ['id' => 126, 'vessel_id' => 19, 'date' => '2025-04-01', 'invoice_no' => '2597', 'port' => 'FYONES', 'description' => 'MGO 59.898* 795 USD', 'amount' => 47618.91, 'due_date' => '2025-05-01', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-09 07:34:20', 'updated_at' => '2025-04-09 07:34:20'],
            ['id' => 127, 'vessel_id' => 17, 'date' => '2025-04-14', 'invoice_no' => '2644', 'port' => 'DAMIETTA', 'description' => 'CYLINDER 40-70-4000 L* 2.15 . + ENGINE 30 -1000 L*1.94  + GENERATOR E 15 W 40 2 DRUMS *585 USD ', 'amount' => 12660.00, 'due_date' => '2025-05-14', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-11 10:48:47', 'updated_at' => '2025-04-11 10:48:47'],
            ['id' => 128, 'vessel_id' => 8, 'date' => '2025-04-22', 'invoice_no' => '2654', 'port' => 'Sevilla', 'description' => 'MOBILGARD M 440   // 2.24\r\nMOBILGARD HSD 15W40  // 628\r\nMOBIL DTE 10 EXCEL 32  // 693 \r\nMOBIL DTE 10 EXCEL 46  // 694 ', 'amount' => 11270.00, 'due_date' => '2025-05-22', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-11 12:25:41', 'updated_at' => '2025-04-11 12:25:41'],
            ['id' => 129, 'vessel_id' => 15, 'date' => '2025-04-17', 'invoice_no' => '2643', 'port' => 'Malta', 'description' => 'MGO 70 MTS * 670 USD ', 'amount' => 48520.00, 'due_date' => '2025-05-19', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-16 09:31:16', 'updated_at' => '2025-04-16 09:31:16'],
            ['id' => 130, 'vessel_id' => 18, 'date' => '2025-04-16', 'invoice_no' => '2659', 'port' => 'Huelva ', 'description' => 'MGO 27 MTS *678 USD', 'amount' => 18240.23, 'due_date' => '2025-05-21', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-16 09:47:18', 'updated_at' => '2025-04-16 09:47:18'],
        ];

        DB::table('vessel_records')->insert($records);
    }

    private function importVesselRecordsPart3()
    {
        // Import vessel records exactly from SQL - Part 3 (records 131-189)
        $records = [
            ['id' => 131, 'vessel_id' => 15, 'date' => '2025-04-19', 'invoice_no' => '2647', 'port' => 'Misurata', 'description' => 'Maximarine CYL 40 /4 DRUM *605 USD ', 'amount' => 2570.00, 'due_date' => '2025-05-21', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-23 07:00:55', 'updated_at' => '2025-04-23 07:00:55'],
            ['id' => 132, 'vessel_id' => 6, 'date' => '2025-04-26', 'invoice_no' => '2684', 'port' => 'ISTANBUL', 'description' => 'MGO 120 MTS *710 USD ', 'amount' => 86700.00, 'due_date' => '2025-05-26', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-23 07:05:30', 'updated_at' => '2025-04-23 07:05:30'],
            ['id' => 133, 'vessel_id' => 9, 'date' => '2025-04-23', 'invoice_no' => '2703', 'port' => 'Vassiliko', 'description' => 'l.oil 3000l*3.1+ l.oil 3 drum *825 ', 'amount' => 12480.00, 'due_date' => '2025-05-25', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-23 07:18:56', 'updated_at' => '2025-04-23 07:18:56'],
            ['id' => 134, 'vessel_id' => 7, 'date' => '2025-02-26', 'invoice_no' => '2408', 'port' => 'ISTANBUL', 'description' => 'MGO 25*755 + L.OIL 4416*3 ', 'amount' => 30616.00, 'due_date' => '2025-03-28', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-23 08:52:42', 'updated_at' => '2025-04-23 08:52:42'],
            ['id' => 135, 'vessel_id' => 19, 'date' => '2025-04-23', 'invoice_no' => '2679', 'port' => 'Algiers', 'description' => 'MGO 160*683 USD ', 'amount' => 112197.13, 'due_date' => '2025-05-23', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-24 07:23:53', 'updated_at' => '2025-04-24 07:23:53'],
            ['id' => 136, 'vessel_id' => 18, 'date' => '2025-04-28', 'invoice_no' => '2737', 'port' => 'DRIPANO', 'description' => 'MGO 75-81 MTS ', 'amount' => 59616.50, 'due_date' => '2025-05-29', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-28 08:24:33', 'updated_at' => '2025-04-28 08:24:33'],
            ['id' => 137, 'vessel_id' => 17, 'date' => '2025-05-01', 'invoice_no' => '2727', 'port' => 'Lisbon', 'description' => 'MGO 50 MTS *698', 'amount' => 37697.58, 'due_date' => '2025-05-31', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-04-28 11:47:17', 'updated_at' => '2025-04-28 11:47:17'],
            ['id' => 138, 'vessel_id' => 13, 'date' => '2025-05-02', 'invoice_no' => '2734', 'port' => 'MALTA', 'description' => 'MGO 60 MTS* 690  ', 'amount' => 44400.00, 'due_date' => '2025-06-02', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-02 09:11:41', 'updated_at' => '2025-05-02 09:11:41'],
            ['id' => 139, 'vessel_id' => 16, 'date' => '2025-05-08', 'invoice_no' => '2750', 'port' => 'Gdansk', 'description' => 'Shell Alexia 40/5000*2.33+Shell Melina S 30/3000*2.15 + Shell Argina S3 30/2000*2.16', 'amount' => 109520.00, 'due_date' => '2025-06-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-02 09:14:35', 'updated_at' => '2025-05-02 09:14:35'],
            ['id' => 140, 'vessel_id' => 13, 'date' => '2025-05-08', 'invoice_no' => '2786', 'port' => 'Tarragona ', 'description' => '4000 L Mobilgard 540 * 2.18', 'amount' => 8436.63, 'due_date' => '2025-06-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-06 08:49:07', 'updated_at' => '2025-05-06 08:49:07'],
            ['id' => 141, 'vessel_id' => 7, 'date' => '2025-05-11', 'invoice_no' => '2784', 'port' => 'Malta', 'description' => 'MGO 50 MTS * 705 ', 'amount' => 36840.00, 'due_date' => '2025-06-11', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-08 10:32:07', 'updated_at' => '2025-05-08 10:32:07'],
            ['id' => 142, 'vessel_id' => 15, 'date' => '2025-05-08', 'invoice_no' => '2796', 'port' => 'Liverpool ', 'description' => 'MGO 30 MTS *705', 'amount' => 20726.30, 'due_date' => '2025-06-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-08 10:35:08', 'updated_at' => '2025-05-08 10:35:08'],
            ['id' => 143, 'vessel_id' => 20, 'date' => '2025-05-10', 'invoice_no' => '2779', 'port' => 'ZARKIS', 'description' => 'MGO 53 MTS* 762', 'amount' => 40579.55, 'due_date' => '2025-06-08', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-08 10:36:05', 'updated_at' => '2025-05-08 10:36:05'],
            ['id' => 144, 'vessel_id' => 13, 'date' => '2025-05-13', 'invoice_no' => '02794', 'port' => 'Algiers', 'description' => 'VLSFO 517 MTS * 475 ', 'amount' => 249036.34, 'due_date' => '2025-06-13', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-12 06:47:17', 'updated_at' => '2025-05-12 06:47:17'],
            ['id' => 145, 'vessel_id' => 12, 'date' => '2025-05-14', 'invoice_no' => '02845 ', 'port' => 'Oran', 'description' => 'vlsfo 400 MTS*475 ', 'amount' => 170681.02, 'due_date' => '2025-06-14', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-12 06:48:55', 'updated_at' => '2025-05-12 06:48:55'],
            ['id' => 146, 'vessel_id' => 9, 'date' => '2025-05-15', 'invoice_no' => '2820', 'port' => 'Mostaganem ', 'description' => 'MGO 22.177 MTS * 692 ', 'amount' => 15703.48, 'due_date' => '2025-06-15', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-12 06:51:31', 'updated_at' => '2025-05-12 06:51:31'],
            ['id' => 147, 'vessel_id' => 12, 'date' => '2025-05-08', 'invoice_no' => '2763', 'port' => 'Tripoli', 'description' => 'MGO 80 MTS * 650 + Maximarine CYL 20 drum* 640+ generator oil  15 drum *660', 'amount' => 74700.00, 'due_date' => '2025-06-07', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-12 06:56:36', 'updated_at' => '2025-05-12 06:56:36'],
            ['id' => 148, 'vessel_id' => 6, 'date' => '2025-03-17', 'invoice_no' => '2492', 'port' => 'ISTANBUL', 'description' => 'VLSFO 50 MTS* 556+ MGO 30* 712 ', 'amount' => 52410.00, 'due_date' => '2025-04-17', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-12 12:34:42', 'updated_at' => '2025-05-12 12:34:42'],
            ['id' => 149, 'vessel_id' => 17, 'date' => '2025-05-19', 'invoice_no' => '2823', 'port' => 'MALTA', 'description' => 'MGO 59 MTS *720', 'amount' => 45480.00, 'due_date' => '2025-06-19', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-16 09:29:56', 'updated_at' => '2025-05-16 09:29:56'],
            ['id' => 150, 'vessel_id' => 14, 'date' => '2025-05-18', 'invoice_no' => '2817', 'port' => 'San Lorenzo', 'description' => 'Shell Alexia 40 /3000*3.66+ Shell Melina S 30/4000*3.27', 'amount' => 25260.00, 'due_date' => '2025-06-18', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-19 10:20:53', 'updated_at' => '2025-05-19 10:20:53'],
        ];

        DB::table('vessel_records')->insert($records);

        // Continue with remaining records (151-189)
        $moreRecords = [
            ['id' => 151, 'vessel_id' => 8, 'date' => '2025-03-27', 'invoice_no' => '2546', 'port' => 'Misurata', 'description' => 'VLSFO 95 MTS *490 + MGO 10 MTS* 720.66 ', 'amount' => 53675.52, 'due_date' => '2025-04-27', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-20 09:10:58', 'updated_at' => '2025-05-20 09:10:58'],
            ['id' => 152, 'vessel_id' => 9, 'date' => '2025-05-20', 'invoice_no' => '2828', 'port' => 'Algiers', 'description' => 'VLSFO 40 MTS *475 + MGO 78 MTS *697', 'amount' => 80472.14, 'due_date' => '2025-06-20', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-21 11:47:36', 'updated_at' => '2025-05-21 11:47:36'],
            ['id' => 153, 'vessel_id' => 15, 'date' => '2025-05-21', 'invoice_no' => '2911', 'port' => 'Gdansk', 'description' => 'MGO 100 MTS *672 + L.OIL 9418 *3 ', 'amount' => 108975.11, 'due_date' => '2025-06-20', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-21 11:52:06', 'updated_at' => '2025-05-21 11:52:06'],
            ['id' => 154, 'vessel_id' => 13, 'date' => '2025-05-18', 'invoice_no' => '2837', 'port' => 'LAS PALM', 'description' => 'ثمن دهان', 'amount' => 3166.03, 'due_date' => '2025-06-18', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-26 07:27:35', 'updated_at' => '2025-05-26 07:27:35'],
            ['id' => 155, 'vessel_id' => 14, 'date' => '2025-05-24', 'invoice_no' => '2841', 'port' => 'Zona Comun', 'description' => 'VLSFO 399.960 *594', 'amount' => 237576.24, 'due_date' => '2025-06-23', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-26 08:19:10', 'updated_at' => '2025-05-26 08:19:10'],
            ['id' => 156, 'vessel_id' => 19, 'date' => '2025-05-27', 'invoice_no' => '2849', 'port' => 'Hereke', 'description' => 'VLSFO 100*622+ MGO 20* 708', 'amount' => 79860.00, 'due_date' => '2025-06-26', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-05-26 10:35:44', 'updated_at' => '2025-05-26 10:35:44'],
            ['id' => 157, 'vessel_id' => 8, 'date' => '2025-06-13', 'invoice_no' => '2968', 'port' => 'LE TREPORT', 'description' => 'MGO 60 MTS *728', 'amount' => 43578.08, 'due_date' => '2025-07-12', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-03 11:23:01', 'updated_at' => '2025-06-03 11:23:01'],
            ['id' => 158, 'vessel_id' => 9, 'date' => '2025-06-09', 'invoice_no' => '2908', 'port' => 'Algiers', 'description' => 'VLSFO 90.059 MTS * 514 ', 'amount' => 49945.91, 'due_date' => '2025-07-08', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-05 10:29:51', 'updated_at' => '2025-06-05 10:29:51'],
            ['id' => 159, 'vessel_id' => 22, 'date' => '2025-06-05', 'invoice_no' => '2909', 'port' => 'Arzew', 'description' => 'VLSFO 350*514 + MGO 50 *716', 'amount' => 219206.08, 'due_date' => '2025-07-04', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-05 10:31:12', 'updated_at' => '2025-06-05 10:31:12'],
            ['id' => 160, 'vessel_id' => 13, 'date' => '2025-06-10', 'invoice_no' => '2984', 'port' => 'Paranagua', 'description' => 'MGO 30 MTS * 832 USD ', 'amount' => 25965.74, 'due_date' => '2025-07-22', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-10 07:06:08', 'updated_at' => '2025-06-10 07:06:08'],
            ['id' => 161, 'vessel_id' => 16, 'date' => '2025-05-31', 'invoice_no' => '2907', 'port' => 'LAS PALM', 'description' => 'VLSFO 400 MTS *518 ', 'amount' => 207200.00, 'due_date' => '2025-06-30', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-06-10 07:10:32', 'updated_at' => '2025-06-10 07:10:32'],
            ['id' => 163, 'vessel_id' => 9, 'date' => '2025-06-15', 'invoice_no' => '2966', 'port' => 'Setubal ', 'description' => 'Shell Alexia 40 /5000 L *2.27 USD + Shell Rimula R4 X 15W40 / 208 L *4.15 USD', 'amount' => 13367.35, 'due_date' => '2025-07-14', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-12 07:42:45', 'updated_at' => '2025-06-12 07:42:45'],
            ['id' => 164, 'vessel_id' => 19, 'date' => '2025-06-12', 'invoice_no' => '02962', 'port' => 'Birkenhead ', 'description' => 'MGO 30 MTS*737 USD', 'amount' => 21142.32, 'due_date' => '2025-07-13', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-12 07:44:28', 'updated_at' => '2025-06-12 07:44:28'],
            ['id' => 165, 'vessel_id' => 14, 'date' => '2025-06-14', 'invoice_no' => null, 'port' => 'Las Palmas', 'description' => 'VLSFO 100 MTS*537 + MGO 10 MTS* 730', 'amount' => null, 'due_date' => '2025-07-13', 'company' => 'ENZO', 'status_id' => 7, 'created_by' => null, 'created_at' => '2025-06-13 08:12:19', 'updated_at' => '2025-06-13 08:12:19'],
            ['id' => 166, 'vessel_id' => 15, 'date' => '2025-06-13', 'invoice_no' => '2935', 'port' => 'Arzew', 'description' => 'VLSFO 110 MTS *531 + MGO 130 MTS*721', 'amount' => 147657.42, 'due_date' => '2025-07-12', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-14 20:19:33', 'updated_at' => '2025-06-14 20:19:33'],
            ['id' => 167, 'vessel_id' => 18, 'date' => '2025-06-15', 'invoice_no' => '2969', 'port' => 'Mostaganem ', 'description' => 'MGO 40 MTS*724 USD ', 'amount' => 29527.03, 'due_date' => '2025-07-14', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-16 08:32:27', 'updated_at' => '2025-06-16 08:32:27'],
            ['id' => 168, 'vessel_id' => 20, 'date' => '2025-06-20', 'invoice_no' => '3044', 'port' => 'Stylida ', 'description' => 'MGO 75 MTS * 840 + Shell Gadinia S3 40 /3000L *2.6', 'amount' => 70583.88, 'due_date' => '2025-07-23', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-20 09:27:44', 'updated_at' => '2025-06-20 09:27:44'],
            ['id' => 169, 'vessel_id' => 13, 'date' => '2025-06-25', 'invoice_no' => '3004', 'port' => 'Paranaque', 'description' => 'VLSFO 380 CST Max 0.5 /400 MTS * 602', 'amount' => 240890.30, 'due_date' => '2025-07-27', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-25 11:58:54', 'updated_at' => '2025-06-25 11:58:54'],
            ['id' => 170, 'vessel_id' => 22, 'date' => '2025-06-24', 'invoice_no' => '3002', 'port' => 'Algiers', 'description' => 'VLSFO 300 MTS*563 + MGO 100 *783 ', 'amount' => 253003.11, 'due_date' => '2025-07-25', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-27 09:19:07', 'updated_at' => '2025-06-27 09:19:07'],
            ['id' => 171, 'vessel_id' => 19, 'date' => '2025-06-26', 'invoice_no' => '03041 ', 'port' => 'Gdansk', 'description' => 'L.OIL 6627 L* 2.7 ', 'amount' => 147623.55, 'due_date' => '2025-08-02', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-27 09:20:56', 'updated_at' => '2025-06-27 09:20:56'],
            ['id' => 172, 'vessel_id' => 8, 'date' => '2025-06-23', 'invoice_no' => '2899', 'port' => 'Gdansk', 'description' => 'MGO 50 MTS * 828 ', 'amount' => 41096.12, 'due_date' => '2025-07-24', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-06-30 08:41:35', 'updated_at' => '2025-06-30 08:41:35'],
            ['id' => 173, 'vessel_id' => 21, 'date' => '2025-07-25', 'invoice_no' => '3142', 'port' => 'Gdansk', 'description' => 'Shell Alexia 40 4,000 L * 2.32+ Shell Tellus S2 V 68 4 Drum*752.40 + ULSFO 130 MTS * 685 +MGO 70 MTS * 780 USD', 'amount' => 154833.64, 'due_date' => '2025-08-25', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-01 08:09:20', 'updated_at' => '2025-07-01 08:09:20'],
            ['id' => 174, 'vessel_id' => 9, 'date' => '2025-07-06', 'invoice_no' => '3022', 'port' => 'Oran', 'description' => 'VLSFO 85 MTS *548 USD + MGO 100 MTS *765 USD', 'amount' => 126030.03, 'due_date' => '2025-07-31', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-07 07:53:15', 'updated_at' => '2025-07-07 07:53:15'],
            ['id' => 175, 'vessel_id' => 17, 'date' => '2025-07-09', 'invoice_no' => '3045', 'port' => 'Istanbul', 'description' => 'MGO 75 MTS* 830 USD', 'amount' => 63750.00, 'due_date' => '2025-08-09', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-08 10:24:25', 'updated_at' => '2025-07-08 10:24:25'],
            ['id' => 176, 'vessel_id' => 20, 'date' => '2025-07-09', 'invoice_no' => '3059', 'port' => 'Venice ', 'description' => 'MGO 30 MTS* 910 USD', 'amount' => 28797.27, 'due_date' => '2025-08-08', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-08 11:58:01', 'updated_at' => '2025-07-08 11:58:01'],
            ['id' => 177, 'vessel_id' => 22, 'date' => '2025-07-12', 'invoice_no' => '3066', 'port' => 'ISTANBUL', 'description' => 'VLSFO 50 MTS*665 +MGO 25 MTS *830+L.OIL 10000 L *2.2+2 PAILS *140 ', 'amount' => 79920.00, 'due_date' => '2025-08-12', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-11 08:51:18', 'updated_at' => '2025-07-11 08:51:18'],
            ['id' => 178, 'vessel_id' => 12, 'date' => '2025-07-14', 'invoice_no' => '3081', 'port' => 'Algiers', 'description' => 'VLSFO 300 MTS *550 USD', 'amount' => 169158.89, 'due_date' => '2025-08-14', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-14 10:45:50', 'updated_at' => '2025-07-14 10:45:50'],
            ['id' => 179, 'vessel_id' => 8, 'date' => '2025-07-10', 'invoice_no' => '3069', 'port' => 'Algiers', 'description' => 'VLSFO 100 MTS *550 + MGO 30 MTS*770', 'amount' => 80974.09, 'due_date' => '2025-08-11', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-14 10:47:06', 'updated_at' => '2025-07-14 10:47:06'],
            ['id' => 180, 'vessel_id' => 6, 'date' => '2025-07-15', 'invoice_no' => '3076', 'port' => 'Tarragona ', 'description' => 'MGO 26.464 MTS *805', 'amount' => 21303.52, 'due_date' => '2025-08-14', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-15 06:09:34', 'updated_at' => '2025-07-15 06:09:34'],
            ['id' => 181, 'vessel_id' => 21, 'date' => '2025-05-09', 'invoice_no' => '2765', 'port' => 'Tripoli', 'description' => 'MGO 60 MTS *650 ', 'amount' => 39000.00, 'due_date' => '2025-06-09', 'company' => 'ENZO', 'status_id' => 8, 'created_by' => null, 'created_at' => '2025-07-15 07:23:33', 'updated_at' => '2025-07-15 07:23:33'],
            ['id' => 182, 'vessel_id' => 18, 'date' => '2025-07-22', 'invoice_no' => '3111', 'port' => 'Iskenderun', 'description' => 'Castrol TLX 4-40 //1,456 L *2.95', 'amount' => 5495.20, 'due_date' => '2025-08-20', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-18 11:01:28', 'updated_at' => '2025-07-18 11:01:28'],
            ['id' => 183, 'vessel_id' => 6, 'date' => '2025-07-19', 'invoice_no' => '3105', 'port' => 'Oran', 'description' => 'VLSFO 50 MTS*538 ', 'amount' => 28096.46, 'due_date' => '2025-08-19', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-18 13:06:14', 'updated_at' => '2025-07-18 13:06:14'],
            ['id' => 184, 'vessel_id' => 13, 'date' => '2025-07-26', 'invoice_no' => null, 'port' => 'Djibouti', 'description' => 'Castrol Cyltech 40SX 10 drum*790 USD', 'amount' => null, 'due_date' => '2025-08-26', 'company' => 'ENZO', 'status_id' => 7, 'created_by' => null, 'created_at' => '2025-07-28 07:07:54', 'updated_at' => '2025-07-28 07:07:54'],
            ['id' => 185, 'vessel_id' => 20, 'date' => '2025-07-25', 'invoice_no' => '3123', 'port' => 'Nemrut Bay', 'description' => 'MGO 25 MTS*900 USD', 'amount' => 22500.00, 'due_date' => '2025-08-24', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-28 07:15:47', 'updated_at' => '2025-07-28 07:15:47'],
            ['id' => 186, 'vessel_id' => 15, 'date' => '2025-07-30', 'invoice_no' => '3144', 'port' => 'Aalborg', 'description' => 'Shell Alexia 40 / 5500 L*2.35 + Shell Rimula R4 X 15W40/209 L *4.15 ', 'amount' => 12617.35, 'due_date' => '2025-08-28', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-28 11:15:50', 'updated_at' => '2025-07-28 11:15:50'],
            ['id' => 187, 'vessel_id' => 15, 'date' => '2025-07-30', 'invoice_no' => null, 'port' => 'Skaw ', 'description' => 'VLSFO 130 MTS *695 USD + MGO 20 MTS *770 USD', 'amount' => null, 'due_date' => '2025-08-30', 'company' => 'ENZO', 'status_id' => 7, 'created_by' => null, 'created_at' => '2025-07-28 11:17:25', 'updated_at' => '2025-07-28 11:17:25'],
            ['id' => 188, 'vessel_id' => 17, 'date' => '2025-07-29', 'invoice_no' => '3148', 'port' => 'CASABLANCA', 'description' => 'Marine Gard 540 / 7 DRUM *725 USD', 'amount' => 5475.00, 'due_date' => '2025-08-29', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-29 09:29:04', 'updated_at' => '2025-07-29 09:29:04'],
            ['id' => 189, 'vessel_id' => 9, 'date' => '2025-07-31', 'invoice_no' => '3149', 'port' => 'ISTANBUL', 'description' => 'VLSFO 70 MTS *650 + OIL 3664*3.5 USD ', 'amount' => 56564.00, 'due_date' => '2025-08-30', 'company' => 'ENZO', 'status_id' => 9, 'created_by' => null, 'created_at' => '2025-07-30 08:03:45', 'updated_at' => '2025-07-30 08:03:45'],
        ];

        DB::table('vessel_records')->insert($moreRecords);
    }

    public function importRecordAttachments()
    {
        // Clear existing attachments first
        DB::table('record_attachments')->truncate();

        // Import ALL record attachments exactly from the original SQL
        $this->importAttachmentsPart1();
        $this->importAttachmentsPart2();
        $this->importAttachmentsPart3();
        $this->importAttachmentsPart4();
    }

    private function importAttachmentsPart1()
    {
        // Import attachments part 1 (IDs 21-150)
        $attachments = [
            ['id' => 21, 'record_id' => 66, 'file_name' => 'S02272.pdf', 'file_path' => '677cc995234d2_S02272.pdf', 'uploaded_at' => '2025-01-07 06:28:37'],
            ['id' => 23, 'record_id' => 68, 'file_name' => 'S02274.pdf', 'file_path' => '677ccc077fef5_S02274.pdf', 'uploaded_at' => '2025-01-07 06:39:03'],
            ['id' => 24, 'record_id' => 69, 'file_name' => 'S02279.pdf', 'file_path' => '677e20ad6ca94_S02279.pdf', 'uploaded_at' => '2025-01-08 06:52:29'],
            ['id' => 25, 'record_id' => 70, 'file_name' => 'S02287.pdf', 'file_path' => '677f711002b40_S02287.pdf', 'uploaded_at' => '2025-01-09 06:47:44'],
            ['id' => 28, 'record_id' => 69, 'file_name' => 'BDN-00035.pdf', 'file_path' => '6784baf17c95d_BDN-00035.pdf', 'uploaded_at' => '2025-01-13 07:04:17'],
            ['id' => 29, 'record_id' => 69, 'file_name' => 'INV_2025_00035.pdf', 'file_path' => '6784baf17f34e_INV_2025_00035.pdf', 'uploaded_at' => '2025-01-13 07:04:17'],
            ['id' => 30, 'record_id' => 68, 'file_name' => 'INV_2025_00039.pdf', 'file_path' => '67860ec6298cb_INV_2025_00039.pdf', 'uploaded_at' => '2025-01-14 07:14:14'],
            ['id' => 31, 'record_id' => 68, 'file_name' => 'BDN-00039.pdf', 'file_path' => '67860ed076ef0_BDN-00039.pdf', 'uploaded_at' => '2025-01-14 07:14:24'],
            ['id' => 32, 'record_id' => 72, 'file_name' => 'S02264.pdf', 'file_path' => '67861135670ff_S02264.pdf', 'uploaded_at' => '2025-01-14 07:24:37'],
            ['id' => 33, 'record_id' => 72, 'file_name' => 'BDN-00038.pdf', 'file_path' => '67861143afe2d_BDN-00038.pdf', 'uploaded_at' => '2025-01-14 07:24:51'],
            ['id' => 34, 'record_id' => 72, 'file_name' => 'INV_2025_00038.pdf', 'file_path' => '67861143b0153_INV_2025_00038.pdf', 'uploaded_at' => '2025-01-14 07:24:51'],
            ['id' => 35, 'record_id' => 70, 'file_name' => 'INV_2025_00041.pdf', 'file_path' => '678612999bc13_INV_2025_00041.pdf', 'uploaded_at' => '2025-01-14 07:30:33'],
            ['id' => 36, 'record_id' => 70, 'file_name' => 'BDN-00041.pdf', 'file_path' => '678612999befa_BDN-00041.pdf', 'uploaded_at' => '2025-01-14 07:30:33'],
            ['id' => 37, 'record_id' => 73, 'file_name' => 'S02296.pdf', 'file_path' => '678614ba5ca4a_S02296.pdf', 'uploaded_at' => '2025-01-14 07:39:38'],
            ['id' => 42, 'record_id' => 76, 'file_name' => 'S02299.pdf', 'file_path' => '1736923380_S02299.pdf', 'uploaded_at' => '2025-01-15 06:43:00'],
            ['id' => 43, 'record_id' => 66, 'file_name' => 'INV_2025_00045.pdf', 'file_path' => '1737013615_INV_2025_00045.pdf', 'uploaded_at' => '2025-01-16 07:46:55'],
            ['id' => 44, 'record_id' => 66, 'file_name' => 'BDN-00045.pdf', 'file_path' => '1737013615_BDN-00045.pdf', 'uploaded_at' => '2025-01-16 07:46:55'],
            ['id' => 45, 'record_id' => 73, 'file_name' => 'BDN-00061.pdf', 'file_path' => '1737361200_BDN-00061.pdf', 'uploaded_at' => '2025-01-20 08:20:00'],
            ['id' => 46, 'record_id' => 73, 'file_name' => 'INV_2025_00061.pdf', 'file_path' => '1737361200_INV_2025_00061.pdf', 'uploaded_at' => '2025-01-20 08:20:00'],
            ['id' => 48, 'record_id' => 67, 'file_name' => 'BDN-00062.pdf', 'file_path' => '1737361328_BDN-00062.pdf', 'uploaded_at' => '2025-01-20 08:22:08'],
            ['id' => 49, 'record_id' => 76, 'file_name' => 'INV_2025_00063.pdf', 'file_path' => '1737362826_INV_2025_00063.pdf', 'uploaded_at' => '2025-01-20 08:47:06'],
            ['id' => 50, 'record_id' => 76, 'file_name' => 'BDN-00063.pdf', 'file_path' => '1737362826_BDN-00063.pdf', 'uploaded_at' => '2025-01-20 08:47:06'],
            ['id' => 51, 'record_id' => 77, 'file_name' => 'S02317.pdf', 'file_path' => '1737362914_S02317.pdf', 'uploaded_at' => '2025-01-20 08:48:34'],
            ['id' => 53, 'record_id' => 79, 'file_name' => 'S02330.pdf', 'file_path' => '1737543805_S02330.pdf', 'uploaded_at' => '2025-01-22 11:03:25'],
            ['id' => 54, 'record_id' => 80, 'file_name' => 'S02332.pdf', 'file_path' => '1737543933_S02332.pdf', 'uploaded_at' => '2025-01-22 11:05:33'],
            ['id' => 55, 'record_id' => 78, 'file_name' => 'S02324.pdf', 'file_path' => '1737624911_S02324.pdf', 'uploaded_at' => '2025-01-23 09:35:11'],
            ['id' => 56, 'record_id' => 81, 'file_name' => 'S02337.pdf', 'file_path' => '1737711910_S02337.pdf', 'uploaded_at' => '2025-01-24 09:45:10'],
            ['id' => 57, 'record_id' => 77, 'file_name' => 'INV_2025_00083.pdf', 'file_path' => '1737712009_INV_2025_00083.pdf', 'uploaded_at' => '2025-01-24 09:46:49'],
            ['id' => 58, 'record_id' => 77, 'file_name' => 'BDN-00083.pdf', 'file_path' => '1737712009_BDN-00083.pdf', 'uploaded_at' => '2025-01-24 09:46:49'],
            ['id' => 59, 'record_id' => 80, 'file_name' => 'INV_2025_00086.pdf', 'file_path' => '1737712086_INV_2025_00086.pdf', 'uploaded_at' => '2025-01-24 09:48:06'],
            ['id' => 60, 'record_id' => 80, 'file_name' => 'BDN-00086.pdf', 'file_path' => '1737712086_BDN-00086.pdf', 'uploaded_at' => '2025-01-24 09:48:06'],
            ['id' => 61, 'record_id' => 79, 'file_name' => 'INV_2025_00088.pdf', 'file_path' => '1737967325_INV_2025_00088.pdf', 'uploaded_at' => '2025-01-27 08:42:05'],
            ['id' => 62, 'record_id' => 79, 'file_name' => 'BDN-00088.pdf', 'file_path' => '1737967325_BDN-00088.pdf', 'uploaded_at' => '2025-01-27 08:42:05'],
            ['id' => 63, 'record_id' => 78, 'file_name' => 'INV_2025_00091.pdf', 'file_path' => '1737968321_INV_2025_00091.pdf', 'uploaded_at' => '2025-01-27 08:58:41'],
            ['id' => 64, 'record_id' => 78, 'file_name' => 'BDN-00091.pdf', 'file_path' => '1737968321_BDN-00091.pdf', 'uploaded_at' => '2025-01-27 08:58:41'],
            ['id' => 65, 'record_id' => 82, 'file_name' => 'S02355.pdf', 'file_path' => '1738053570_S02355.pdf', 'uploaded_at' => '2025-01-28 08:39:30'],
            ['id' => 67, 'record_id' => 84, 'file_name' => 'S02367.pdf', 'file_path' => '1738225330_S02367.pdf', 'uploaded_at' => '2025-01-30 08:22:10'],
            ['id' => 68, 'record_id' => 85, 'file_name' => 'S02354.pdf', 'file_path' => '1738226417_S02354.pdf', 'uploaded_at' => '2025-01-30 08:40:17'],
            ['id' => 69, 'record_id' => 84, 'file_name' => 'INV_2025_02298.pdf', 'file_path' => '1738313029_INV_2025_02298.pdf', 'uploaded_at' => '2025-01-31 08:43:49'],
            ['id' => 70, 'record_id' => 84, 'file_name' => 'BDN-02298.pdf', 'file_path' => '1738313029_BDN-02298.pdf', 'uploaded_at' => '2025-01-31 08:43:49'],
            ['id' => 71, 'record_id' => 85, 'file_name' => 'INV_2025_02299.pdf', 'file_path' => '1738314419_INV_2025_02299.pdf', 'uploaded_at' => '2025-01-31 09:06:59'],
            ['id' => 72, 'record_id' => 85, 'file_name' => 'BDN-02299.pdf', 'file_path' => '1738314419_BDN-02299.pdf', 'uploaded_at' => '2025-01-31 09:06:59'],
            ['id' => 73, 'record_id' => 82, 'file_name' => 'INV_2025_02300.pdf', 'file_path' => '1738317727_INV_2025_02300.pdf', 'uploaded_at' => '2025-01-31 10:02:07'],
            ['id' => 74, 'record_id' => 82, 'file_name' => 'BDN-02300.pdf', 'file_path' => '1738317727_BDN-02300.pdf', 'uploaded_at' => '2025-01-31 10:02:07'],
            ['id' => 75, 'record_id' => 86, 'file_name' => 'S02375.pdf', 'file_path' => '1738318021_S02375.pdf', 'uploaded_at' => '2025-01-31 10:07:01'],
            ['id' => 76, 'record_id' => 81, 'file_name' => 'INV_2025_02292.pdf', 'file_path' => '1738583558_INV_2025_02292.pdf', 'uploaded_at' => '2025-02-03 11:52:38'],
            ['id' => 77, 'record_id' => 81, 'file_name' => 'BDN-02292.pdf', 'file_path' => '1738583558_BDN-02292.pdf', 'uploaded_at' => '2025-02-03 11:52:38'],
            ['id' => 80, 'record_id' => 89, 'file_name' => 'S02385.pdf', 'file_path' => '1738655416_S02385.pdf', 'uploaded_at' => '2025-02-04 07:50:16'],
            ['id' => 81, 'record_id' => 90, 'file_name' => 'S02386.pdf', 'file_path' => '1738655622_S02386.pdf', 'uploaded_at' => '2025-02-04 07:53:42'],
            ['id' => 82, 'record_id' => 91, 'file_name' => 'S02390.pdf', 'file_path' => '1738662305_S02390.pdf', 'uploaded_at' => '2025-02-04 09:45:05'],
            ['id' => 83, 'record_id' => 92, 'file_name' => 'BDN-02322 (002).pdf', 'file_path' => '1738829867_BDN-02322 (002).pdf', 'uploaded_at' => '2025-02-06 08:17:47'],
            ['id' => 84, 'record_id' => 92, 'file_name' => 'INV_2025_02322.pdf', 'file_path' => '1738829867_INV_2025_02322.pdf', 'uploaded_at' => '2025-02-06 08:17:47'],
            ['id' => 85, 'record_id' => 92, 'file_name' => 'S02384.pdf', 'file_path' => '1738829867_S02384.pdf', 'uploaded_at' => '2025-02-06 08:17:47'],
            ['id' => 86, 'record_id' => 94, 'file_name' => 'S02399.pdf', 'file_path' => '1738830495_S02399.pdf', 'uploaded_at' => '2025-02-06 08:28:15'],
            ['id' => 87, 'record_id' => 91, 'file_name' => 'INV_2025_02329-2.pdf', 'file_path' => '1738911814_INV_2025_02329-2.pdf', 'uploaded_at' => '2025-02-07 07:03:34'],
            ['id' => 88, 'record_id' => 91, 'file_name' => 'BDN-02329-3.pdf', 'file_path' => '1738911814_BDN-02329-3.pdf', 'uploaded_at' => '2025-02-07 07:03:34'],
            ['id' => 89, 'record_id' => 89, 'file_name' => 'BDN-02335.pdf', 'file_path' => '1739170771_BDN-02335.pdf', 'uploaded_at' => '2025-02-10 06:59:31'],
            ['id' => 90, 'record_id' => 89, 'file_name' => 'INV_2025_02335.pdf', 'file_path' => '1739170771_INV_2025_02335.pdf', 'uploaded_at' => '2025-02-10 06:59:31'],
            ['id' => 91, 'record_id' => 90, 'file_name' => 'INV_2025_02336.pdf', 'file_path' => '1739170937_INV_2025_02336.pdf', 'uploaded_at' => '2025-02-10 07:02:17'],
            ['id' => 92, 'record_id' => 90, 'file_name' => 'BDN-02336.pdf', 'file_path' => '1739170937_BDN-02336.pdf', 'uploaded_at' => '2025-02-10 07:02:17'],
            ['id' => 93, 'record_id' => 95, 'file_name' => 'S02417-3.pdf', 'file_path' => '1739266070_S02417-3.pdf', 'uploaded_at' => '2025-02-11 09:27:50'],
            ['id' => 94, 'record_id' => 67, 'file_name' => 'INV_2025_00062.pdf', 'file_path' => '1739433819_INV_2025_00062.pdf', 'uploaded_at' => '2025-02-13 08:03:39'],
            ['id' => 95, 'record_id' => 67, 'file_name' => 'BDN-00062.pdf', 'file_path' => '1739433819_BDN-00062.pdf', 'uploaded_at' => '2025-02-13 08:03:39'],
            ['id' => 96, 'record_id' => 96, 'file_name' => 'S02418.pdf', 'file_path' => '1739788927_S02418.pdf', 'uploaded_at' => '2025-02-17 10:42:07'],
            ['id' => 97, 'record_id' => 97, 'file_name' => 'S02430.pdf', 'file_path' => '1739789022_S02430.pdf', 'uploaded_at' => '2025-02-17 10:43:42'],
            ['id' => 98, 'record_id' => 94, 'file_name' => 'INV_2025_02371.pdf', 'file_path' => '1739870800_INV_2025_02371.pdf', 'uploaded_at' => '2025-02-18 09:26:40'],
            ['id' => 99, 'record_id' => 94, 'file_name' => 'BDN-02371.pdf', 'file_path' => '1739870800_BDN-02371.pdf', 'uploaded_at' => '2025-02-18 09:26:40'],
            ['id' => 100, 'record_id' => 98, 'file_name' => 'INV_2025_02372.pdf', 'file_path' => '1739880288_INV_2025_02372.pdf', 'uploaded_at' => '2025-02-18 12:04:48'],
            ['id' => 101, 'record_id' => 98, 'file_name' => 'BDN-02372.pdf', 'file_path' => '1739880288_BDN-02372.pdf', 'uploaded_at' => '2025-02-18 12:04:48'],
            ['id' => 102, 'record_id' => 98, 'file_name' => 'S02431.pdf', 'file_path' => '1739880288_S02431.pdf', 'uploaded_at' => '2025-02-18 12:04:48'],
            ['id' => 104, 'record_id' => 100, 'file_name' => 'S02438.pdf', 'file_path' => '1739962149_S02438.pdf', 'uploaded_at' => '2025-02-19 10:49:09'],
            ['id' => 105, 'record_id' => 101, 'file_name' => 'S02437.pdf', 'file_path' => '1739962332_S02437.pdf', 'uploaded_at' => '2025-02-19 10:52:12'],
            ['id' => 106, 'record_id' => 97, 'file_name' => 'INV_2025_02363.pdf', 'file_path' => '1739963455_INV_2025_02363.pdf', 'uploaded_at' => '2025-02-19 11:10:55'],
            ['id' => 107, 'record_id' => 97, 'file_name' => 'BDN-02363.PDF', 'file_path' => '1739963455_BDN-02363.PDF', 'uploaded_at' => '2025-02-19 11:10:55'],
            ['id' => 108, 'record_id' => 86, 'file_name' => 'BDN-02375.pdf', 'file_path' => '1740046610_BDN-02375.pdf', 'uploaded_at' => '2025-02-20 10:16:50'],
            ['id' => 109, 'record_id' => 86, 'file_name' => 'INV_2025_02375.pdf', 'file_path' => '1740046610_INV_2025_02375.pdf', 'uploaded_at' => '2025-02-20 10:16:50'],
            ['id' => 110, 'record_id' => 96, 'file_name' => 'INV_2025_02376.pdf', 'file_path' => '1740046743_INV_2025_02376.pdf', 'uploaded_at' => '2025-02-20 10:19:03'],
            ['id' => 111, 'record_id' => 96, 'file_name' => 'BDN-02376.pdf', 'file_path' => '1740046743_BDN-02376.pdf', 'uploaded_at' => '2025-02-20 10:19:03'],
            ['id' => 112, 'record_id' => 100, 'file_name' => 'INV_2025_02381.pdf', 'file_path' => '1740046928_INV_2025_02381.pdf', 'uploaded_at' => '2025-02-20 10:22:08'],
            ['id' => 113, 'record_id' => 100, 'file_name' => 'BDN-02381.pdf', 'file_path' => '1740046928_BDN-02381.pdf', 'uploaded_at' => '2025-02-20 10:22:08'],
            ['id' => 114, 'record_id' => 102, 'file_name' => 'S02462.pdf', 'file_path' => '1740384817_S02462.pdf', 'uploaded_at' => '2025-02-24 08:13:37'],
            ['id' => 115, 'record_id' => 103, 'file_name' => 'S02468.pdf', 'file_path' => '1740566211_S02468.pdf', 'uploaded_at' => '2025-02-26 10:36:51'],
            ['id' => 117, 'record_id' => 105, 'file_name' => 'S02474.pdf', 'file_path' => '1740566418_S02474.pdf', 'uploaded_at' => '2025-02-26 10:40:18'],
            ['id' => 119, 'record_id' => 107, 'file_name' => 'S02490.pdf', 'file_path' => '1740983670_S02490.pdf', 'uploaded_at' => '2025-03-03 06:34:30'],
            ['id' => 120, 'record_id' => 95, 'file_name' => 'INV_2025_02407.pdf', 'file_path' => '1740984171_INV_2025_02407.pdf', 'uploaded_at' => '2025-03-03 06:42:51'],
            ['id' => 121, 'record_id' => 95, 'file_name' => 'BDN-02407.pdf', 'file_path' => '1740984171_BDN-02407.pdf', 'uploaded_at' => '2025-03-03 06:42:51'],
            ['id' => 122, 'record_id' => 101, 'file_name' => 'INV_2025_02412.pdf', 'file_path' => '1740990249_INV_2025_02412.pdf', 'uploaded_at' => '2025-03-03 08:24:09'],
            ['id' => 123, 'record_id' => 101, 'file_name' => 'BDN-02412.pdf', 'file_path' => '1740990249_BDN-02412.pdf', 'uploaded_at' => '2025-03-03 08:24:09'],
            ['id' => 124, 'record_id' => 106, 'file_name' => 'S02489.pdf', 'file_path' => '1741074198_S02489.pdf', 'uploaded_at' => '2025-03-04 07:43:19'],
            ['id' => 125, 'record_id' => 107, 'file_name' => 'INV_2025_02423.pdf', 'file_path' => '1741158061_INV_2025_02423.pdf', 'uploaded_at' => '2025-03-05 07:01:01'],
            ['id' => 126, 'record_id' => 107, 'file_name' => 'BDN-02423.pdf', 'file_path' => '1741158061_BDN-02423.pdf', 'uploaded_at' => '2025-03-05 07:01:01'],
            ['id' => 127, 'record_id' => 103, 'file_name' => 'INV_2025_02426.pdf', 'file_path' => '1741164782_INV_2025_02426.pdf', 'uploaded_at' => '2025-03-05 08:53:02'],
            ['id' => 128, 'record_id' => 103, 'file_name' => 'BDN-02426.pdf', 'file_path' => '1741164782_BDN-02426.pdf', 'uploaded_at' => '2025-03-05 08:53:02'],
            ['id' => 129, 'record_id' => 76, 'file_name' => 'SWIFT 5-3-2025.pdf', 'file_path' => '1741716141_SWIFT 5-3-2025.pdf', 'uploaded_at' => '2025-03-11 18:02:21'],
            ['id' => 130, 'record_id' => 108, 'file_name' => 'S02521.pdf', 'file_path' => '1741847456_S02521.pdf', 'uploaded_at' => '2025-03-13 06:30:56'],
            ['id' => 131, 'record_id' => 109, 'file_name' => 'S02494.pdf', 'file_path' => '1741847662_S02494.pdf', 'uploaded_at' => '2025-03-13 06:34:22'],
            ['id' => 132, 'record_id' => 109, 'file_name' => 'INV_2025_02445.pdf', 'file_path' => '1741847662_INV_2025_02445.pdf', 'uploaded_at' => '2025-03-13 06:34:22'],
            ['id' => 133, 'record_id' => 109, 'file_name' => 'BDN-02445.pdf', 'file_path' => '1741847662_BDN-02445.pdf', 'uploaded_at' => '2025-03-13 06:34:22'],
            ['id' => 134, 'record_id' => 110, 'file_name' => 'S02538.pdf', 'file_path' => '1741847774_S02538.pdf', 'uploaded_at' => '2025-03-13 06:36:14'],
            ['id' => 135, 'record_id' => 111, 'file_name' => 'S02548.pdf', 'file_path' => '1741848017_S02548.pdf', 'uploaded_at' => '2025-03-13 06:40:17'],
            ['id' => 136, 'record_id' => 108, 'file_name' => 'INV_2025_02465.pdf', 'file_path' => '1741848093_INV_2025_02465.pdf', 'uploaded_at' => '2025-03-13 06:41:33'],
            ['id' => 137, 'record_id' => 108, 'file_name' => 'BDN-02465.pdf', 'file_path' => '1741848093_BDN-02465.pdf', 'uploaded_at' => '2025-03-13 06:41:33'],
            ['id' => 138, 'record_id' => 112, 'file_name' => 'S02567.pdf', 'file_path' => '1741943691_S02567.pdf', 'uploaded_at' => '2025-03-14 09:14:51'],
            ['id' => 139, 'record_id' => 110, 'file_name' => 'INV_2025_02477.pdf', 'file_path' => '1741945875_INV_2025_02477.pdf', 'uploaded_at' => '2025-03-14 09:51:15'],
            ['id' => 140, 'record_id' => 110, 'file_name' => 'BDN-02477.pdf', 'file_path' => '1741945875_BDN-02477.pdf', 'uploaded_at' => '2025-03-14 09:51:15'],
            ['id' => 141, 'record_id' => 72, 'file_name' => '2103_20250313_154004.pdf', 'file_path' => '1742200585_2103_20250313_154004.pdf', 'uploaded_at' => '2025-03-17 08:36:25'],
            ['id' => 142, 'record_id' => 66, 'file_name' => '2103_20250313_154004.pdf', 'file_path' => '1742200696_2103_20250313_154004.pdf', 'uploaded_at' => '2025-03-17 08:38:16'],
            ['id' => 143, 'record_id' => 73, 'file_name' => '2025.03.14_15.04.32_Export.pdf', 'file_path' => '1742201000_2025.03.14_15.04.32_Export.pdf', 'uploaded_at' => '2025-03-17 08:43:20'],
            ['id' => 144, 'record_id' => 113, 'file_name' => 'S02561.pdf', 'file_path' => '1742201336_S02561.pdf', 'uploaded_at' => '2025-03-17 08:48:56'],
            ['id' => 145, 'record_id' => 114, 'file_name' => 'S02574.pdf', 'file_path' => '1742201438_S02574.pdf', 'uploaded_at' => '2025-03-17 08:50:38'],
            ['id' => 146, 'record_id' => 106, 'file_name' => 'INV_2025_02489.pdf', 'file_path' => '1742203521_INV_2025_02489.pdf', 'uploaded_at' => '2025-03-17 09:25:21'],
            ['id' => 147, 'record_id' => 106, 'file_name' => 'BDN-02489.pdf', 'file_path' => '1742203521_BDN-02489.pdf', 'uploaded_at' => '2025-03-17 09:25:21'],
            ['id' => 148, 'record_id' => 115, 'file_name' => 'S02579.pdf', 'file_path' => '1742284256_S02579.pdf', 'uploaded_at' => '2025-03-18 07:50:56'],
            ['id' => 149, 'record_id' => 112, 'file_name' => 'INV_2025_02496.pdf', 'file_path' => '1742284387_INV_2025_02496.pdf', 'uploaded_at' => '2025-03-18 07:53:07'],
            ['id' => 150, 'record_id' => 112, 'file_name' => 'BDN-02496.pdf', 'file_path' => '1742284387_BDN-02496.pdf', 'uploaded_at' => '2025-03-18 07:53:07'],
        ];

        DB::table('record_attachments')->insert($attachments);
    }

    private function importAttachmentsPart2()
    {
        // Import attachments part 2 (IDs 151-300)
        $attachments = [
            ['id' => 151, 'record_id' => 105, 'file_name' => 'INV_2025_02505.pdf', 'file_path' => '1742372102_INV_2025_02505.pdf', 'uploaded_at' => '2025-03-19 08:15:02'],
            ['id' => 152, 'record_id' => 105, 'file_name' => 'BDN-02505.pdf', 'file_path' => '1742372102_BDN-02505.pdf', 'uploaded_at' => '2025-03-19 08:15:02'],
            ['id' => 153, 'record_id' => 116, 'file_name' => 'S02589.pdf', 'file_path' => '1742460766_S02589.pdf', 'uploaded_at' => '2025-03-20 08:52:46'],
            ['id' => 154, 'record_id' => 96, 'file_name' => '2103_20250320_165839.tif', 'file_path' => '1742479844_2103_20250320_165839.tif', 'uploaded_at' => '2025-03-20 14:10:44'],
            ['id' => 155, 'record_id' => 81, 'file_name' => '2103_20250320_165839.tif', 'file_path' => '1742479877_2103_20250320_165839.tif', 'uploaded_at' => '2025-03-20 14:11:17'],
            ['id' => 156, 'record_id' => 115, 'file_name' => 'INV_2025_02534.pdf', 'file_path' => '1742973199_INV_2025_02534.pdf', 'uploaded_at' => '2025-03-26 07:13:19'],
            ['id' => 157, 'record_id' => 115, 'file_name' => 'BDN-02534.pdf', 'file_path' => '1742973199_BDN-02534.pdf', 'uploaded_at' => '2025-03-26 07:13:19'],
            ['id' => 158, 'record_id' => 114, 'file_name' => 'INV_2025_02536.pdf', 'file_path' => '1742977320_INV_2025_02536.pdf', 'uploaded_at' => '2025-03-26 08:22:00'],
            ['id' => 159, 'record_id' => 114, 'file_name' => 'BDN-02536.pdf', 'file_path' => '1742977320_BDN-02536.pdf', 'uploaded_at' => '2025-03-26 08:22:00'],
            ['id' => 160, 'record_id' => 117, 'file_name' => 'S02617.pdf', 'file_path' => '1743063284_S02617.pdf', 'uploaded_at' => '2025-03-27 08:14:44'],
            ['id' => 162, 'record_id' => 119, 'file_name' => 'S02613.pdf', 'file_path' => '1743063512_S02613.pdf', 'uploaded_at' => '2025-03-27 08:18:32'],
            ['id' => 163, 'record_id' => 120, 'file_name' => 'S02612.pdf', 'file_path' => '1743075119_S02612.pdf', 'uploaded_at' => '2025-03-27 11:31:59'],
            ['id' => 164, 'record_id' => 121, 'file_name' => 'S02640.pdf', 'file_path' => '1743582539_S02640.pdf', 'uploaded_at' => '2025-04-02 08:28:59'],
            ['id' => 165, 'record_id' => 122, 'file_name' => 'S02651.pdf', 'file_path' => '1743591784_S02651.pdf', 'uploaded_at' => '2025-04-02 11:03:04'],
            ['id' => 166, 'record_id' => 121, 'file_name' => 'INV_2025_02565.pdf', 'file_path' => '1743759882_INV_2025_02565.pdf', 'uploaded_at' => '2025-04-04 09:44:42'],
            ['id' => 167, 'record_id' => 121, 'file_name' => 'BDN-02565.pdf', 'file_path' => '1743759882_BDN-02565.pdf', 'uploaded_at' => '2025-04-04 09:44:42'],
            ['id' => 168, 'record_id' => 111, 'file_name' => 'INV_2025_02570.pdf', 'file_path' => '1743760234_INV_2025_02570.pdf', 'uploaded_at' => '2025-04-04 09:50:34'],
            ['id' => 169, 'record_id' => 111, 'file_name' => 'BDN-02570.pdf', 'file_path' => '1743760234_BDN-02570.pdf', 'uploaded_at' => '2025-04-04 09:50:34'],
            ['id' => 170, 'record_id' => 69, 'file_name' => '2025.03.14_15.04.32_Export (1).pdf', 'file_path' => '1744018957_2025.03.14_15.04.32_Export (1).pdf', 'uploaded_at' => '2025-04-07 09:42:37'],
            ['id' => 171, 'record_id' => 120, 'file_name' => 'INV_2025_02573.pdf', 'file_path' => '1744182743_INV_2025_02573.pdf', 'uploaded_at' => '2025-04-09 07:12:23'],
            ['id' => 172, 'record_id' => 120, 'file_name' => 'BDN-02573.pdf', 'file_path' => '1744182743_BDN-02573.pdf', 'uploaded_at' => '2025-04-09 07:12:23'],
            ['id' => 173, 'record_id' => 119, 'file_name' => 'INV_2025_02572.pdf', 'file_path' => '1744182868_INV_2025_02572.pdf', 'uploaded_at' => '2025-04-09 07:14:28'],
            ['id' => 174, 'record_id' => 119, 'file_name' => 'BDN-02572.pdf', 'file_path' => '1744182868_BDN-02572.pdf', 'uploaded_at' => '2025-04-09 07:14:28'],
            ['id' => 175, 'record_id' => 123, 'file_name' => 'S02674.pdf', 'file_path' => '1744182983_S02674.pdf', 'uploaded_at' => '2025-04-09 07:16:23'],
            ['id' => 176, 'record_id' => 117, 'file_name' => 'INV_2025_02578.pdf', 'file_path' => '1744183079_INV_2025_02578.pdf', 'uploaded_at' => '2025-04-09 07:17:59'],
            ['id' => 177, 'record_id' => 117, 'file_name' => 'BDN-02578.pdf', 'file_path' => '1744183079_BDN-02578.pdf', 'uploaded_at' => '2025-04-09 07:17:59'],
            ['id' => 178, 'record_id' => 116, 'file_name' => 'INV_2025_02585.pdf', 'file_path' => '1744183145_INV_2025_02585.pdf', 'uploaded_at' => '2025-04-09 07:19:05'],
            ['id' => 179, 'record_id' => 116, 'file_name' => 'BDN-02585.pdf', 'file_path' => '1744183145_BDN-02585.pdf', 'uploaded_at' => '2025-04-09 07:19:05'],
            ['id' => 180, 'record_id' => 122, 'file_name' => 'INV_2025_02589.pdf', 'file_path' => '1744183189_INV_2025_02589.pdf', 'uploaded_at' => '2025-04-09 07:19:49'],
            ['id' => 181, 'record_id' => 122, 'file_name' => 'BDN-02589.pdf', 'file_path' => '1744183189_BDN-02589.pdf', 'uploaded_at' => '2025-04-09 07:19:49'],
            ['id' => 182, 'record_id' => 124, 'file_name' => 'S02649.pdf', 'file_path' => '1744183258_S02649.pdf', 'uploaded_at' => '2025-04-09 07:20:58'],
            ['id' => 183, 'record_id' => 125, 'file_name' => 'S02678.pdf', 'file_path' => '1744183478_S02678.pdf', 'uploaded_at' => '2025-04-09 07:24:38'],
            ['id' => 184, 'record_id' => 126, 'file_name' => 'INV_2025_02597.pdf', 'file_path' => '1744184060_INV_2025_02597.pdf', 'uploaded_at' => '2025-04-09 07:34:20'],
            ['id' => 185, 'record_id' => 126, 'file_name' => 'BDN-02597.pdf', 'file_path' => '1744184060_BDN-02597.pdf', 'uploaded_at' => '2025-04-09 07:34:20'],
            ['id' => 186, 'record_id' => 123, 'file_name' => 'INV_2025_02600.pdf', 'file_path' => '1744184105_INV_2025_02600.pdf', 'uploaded_at' => '2025-04-09 07:35:05'],
            ['id' => 187, 'record_id' => 123, 'file_name' => 'BDN-02600.pdf', 'file_path' => '1744184105_BDN-02600.pdf', 'uploaded_at' => '2025-04-09 07:35:05'],
            ['id' => 188, 'record_id' => 124, 'file_name' => 'INV_2025_02602.pdf', 'file_path' => '1744184184_INV_2025_02602.pdf', 'uploaded_at' => '2025-04-09 07:36:24'],
            ['id' => 189, 'record_id' => 124, 'file_name' => 'BDN-02602.pdf', 'file_path' => '1744184184_BDN-02602.pdf', 'uploaded_at' => '2025-04-09 07:36:24'],
            ['id' => 190, 'record_id' => 85, 'file_name' => '2103_20250409_105347.pdf', 'file_path' => '1744186555_2103_20250409_105347.pdf', 'uploaded_at' => '2025-04-09 08:15:55'],
            ['id' => 191, 'record_id' => 109, 'file_name' => '2103_20250409_105347.pdf', 'file_path' => '1744186675_2103_20250409_105347.pdf', 'uploaded_at' => '2025-04-09 08:17:55'],
            ['id' => 192, 'record_id' => 82, 'file_name' => '2103_20250409_105347.pdf', 'file_path' => '1744186737_2103_20250409_105347.pdf', 'uploaded_at' => '2025-04-09 08:18:57'],
            ['id' => 193, 'record_id' => 101, 'file_name' => '2103_20250409_105347.pdf', 'file_path' => '1744186818_2103_20250409_105347.pdf', 'uploaded_at' => '2025-04-09 08:20:18'],
            ['id' => 194, 'record_id' => 98, 'file_name' => '2103_20250409_105347.pdf', 'file_path' => '1744186853_2103_20250409_105347.pdf', 'uploaded_at' => '2025-04-09 08:20:53'],
            ['id' => 195, 'record_id' => 80, 'file_name' => 'swift 11-4-2025.pdf', 'file_path' => '1744367325_swift 11-4-2025.pdf', 'uploaded_at' => '2025-04-11 10:28:45'],
            ['id' => 196, 'record_id' => 77, 'file_name' => 'swift 11-4-2025.pdf', 'file_path' => '1744367404_swift 11-4-2025.pdf', 'uploaded_at' => '2025-04-11 10:30:04'],
            ['id' => 197, 'record_id' => 95, 'file_name' => 'swift 11-4-2025.pdf', 'file_path' => '1744367444_swift 11-4-2025.pdf', 'uploaded_at' => '2025-04-11 10:30:44'],
            ['id' => 198, 'record_id' => 67, 'file_name' => 'swift 11-4-2025.pdf', 'file_path' => '1744367470_swift 11-4-2025.pdf', 'uploaded_at' => '2025-04-11 10:31:10'],
            ['id' => 199, 'record_id' => 127, 'file_name' => 'S02687.pdf', 'file_path' => '1744368527_S02687.pdf', 'uploaded_at' => '2025-04-11 10:48:47'],
            ['id' => 200, 'record_id' => 128, 'file_name' => 'S02693.pdf', 'file_path' => '1744374341_S02693.pdf', 'uploaded_at' => '2025-04-11 12:25:41'],
            ['id' => 201, 'record_id' => 125, 'file_name' => 'INV_2025_02614.pdf', 'file_path' => '1744634169_INV_2025_02614.pdf', 'uploaded_at' => '2025-04-14 12:36:09'],
            ['id' => 202, 'record_id' => 125, 'file_name' => 'BDN-02614.pdf', 'file_path' => '1744634169_BDN-02614.pdf', 'uploaded_at' => '2025-04-14 12:36:09'],
            ['id' => 203, 'record_id' => 94, 'file_name' => '2025.04.15_13.28.30_Export.pdf', 'file_path' => '1744713244_2025.04.15_13.28.30_Export.pdf', 'uploaded_at' => '2025-04-15 10:34:04'],
            ['id' => 204, 'record_id' => 106, 'file_name' => '2025.04.15_13.28.30_Export.pdf', 'file_path' => '1744713290_2025.04.15_13.28.30_Export.pdf', 'uploaded_at' => '2025-04-15 10:34:50'],
            ['id' => 205, 'record_id' => 129, 'file_name' => 'S02707.pdf', 'file_path' => '1744795876_S02707.pdf', 'uploaded_at' => '2025-04-16 09:31:16'],
            ['id' => 206, 'record_id' => 130, 'file_name' => 'S02711.pdf', 'file_path' => '1744796838_S02711.pdf', 'uploaded_at' => '2025-04-16 09:47:18'],
            ['id' => 207, 'record_id' => 78, 'file_name' => '2025.04.16_13.32.24_Export.pdf', 'file_path' => '1744799696_2025.04.16_13.32.24_Export.pdf', 'uploaded_at' => '2025-04-16 10:34:56'],
            ['id' => 208, 'record_id' => 129, 'file_name' => 'INV_2025_02643.pdf', 'file_path' => '1745304341_INV_2025_02643.pdf', 'uploaded_at' => '2025-04-22 06:45:41'],
            ['id' => 209, 'record_id' => 129, 'file_name' => 'BDN-02643.pdf', 'file_path' => '1745304341_BDN-02643.pdf', 'uploaded_at' => '2025-04-22 06:45:41'],
            ['id' => 210, 'record_id' => 127, 'file_name' => 'INV_2025_02644.pdf', 'file_path' => '1745304407_INV_2025_02644.pdf', 'uploaded_at' => '2025-04-22 06:46:47'],
            ['id' => 211, 'record_id' => 127, 'file_name' => 'BDN-02644.pdf', 'file_path' => '1745304407_BDN-02644.pdf', 'uploaded_at' => '2025-04-22 06:46:47'],
            ['id' => 212, 'record_id' => 131, 'file_name' => 'S02727.pdf', 'file_path' => '1745391655_S02727.pdf', 'uploaded_at' => '2025-04-23 07:00:55'],
            ['id' => 213, 'record_id' => 131, 'file_name' => 'INV_2025_02647.pdf', 'file_path' => '1745391735_INV_2025_02647.pdf', 'uploaded_at' => '2025-04-23 07:02:15'],
            ['id' => 214, 'record_id' => 131, 'file_name' => 'BDN-02647.pdf', 'file_path' => '1745391735_BDN-02647.pdf', 'uploaded_at' => '2025-04-23 07:02:15'],
            ['id' => 215, 'record_id' => 132, 'file_name' => 'S02738.pdf', 'file_path' => '1745391930_S02738.pdf', 'uploaded_at' => '2025-04-23 07:05:30'],
            ['id' => 216, 'record_id' => 133, 'file_name' => 'S02745.pdf', 'file_path' => '1745392736_S02745.pdf', 'uploaded_at' => '2025-04-23 07:18:56'],
            ['id' => 217, 'record_id' => 128, 'file_name' => 'INV_2025_02654.pdf', 'file_path' => '1745393340_INV_2025_02654.pdf', 'uploaded_at' => '2025-04-23 07:29:00'],
            ['id' => 218, 'record_id' => 128, 'file_name' => 'BDN-02654.pdf', 'file_path' => '1745393340_BDN-02654.pdf', 'uploaded_at' => '2025-04-23 07:29:00'],
            ['id' => 219, 'record_id' => 113, 'file_name' => 'INV_2025_02502.pdf', 'file_path' => '1745393546_INV_2025_02502.pdf', 'uploaded_at' => '2025-04-23 07:32:26'],
            ['id' => 220, 'record_id' => 113, 'file_name' => 'BDN-02502.pdf', 'file_path' => '1745393546_BDN-02502.pdf', 'uploaded_at' => '2025-04-23 07:32:26'],
            ['id' => 221, 'record_id' => 70, 'file_name' => '2103_20250409_105347.pdf', 'file_path' => '1745396576_2103_20250409_105347.pdf', 'uploaded_at' => '2025-04-23 08:22:56'],
            ['id' => 222, 'record_id' => 79, 'file_name' => '2103_20250409_105347.pdf', 'file_path' => '1745396629_2103_20250409_105347.pdf', 'uploaded_at' => '2025-04-23 08:23:49'],
            ['id' => 223, 'record_id' => 134, 'file_name' => 'INV_2025_02408.pdf', 'file_path' => '1745398512_INV_2025_02408.pdf', 'uploaded_at' => '2025-04-23 08:55:12'],
            ['id' => 224, 'record_id' => 134, 'file_name' => 'BDN-02408.pdf', 'file_path' => '1745398512_BDN-02408.pdf', 'uploaded_at' => '2025-04-23 08:55:12'],
            ['id' => 225, 'record_id' => 134, 'file_name' => 'S02465.pdf', 'file_path' => '1745398512_S02465.pdf', 'uploaded_at' => '2025-04-23 08:55:12'],
            ['id' => 226, 'record_id' => 97, 'file_name' => '2103_20250423_142540.pdf', 'file_path' => '1745410178_2103_20250423_142540.pdf', 'uploaded_at' => '2025-04-23 12:09:38'],
            ['id' => 227, 'record_id' => 68, 'file_name' => '2103_20250423_142540.pdf', 'file_path' => '1745410234_2103_20250423_142540.pdf', 'uploaded_at' => '2025-04-23 12:10:34'],
            ['id' => 228, 'record_id' => 84, 'file_name' => '2103_20250423_142540.pdf', 'file_path' => '1745410312_2103_20250423_142540.pdf', 'uploaded_at' => '2025-04-23 12:11:52'],
            ['id' => 229, 'record_id' => 91, 'file_name' => '2103_20250423_142540.pdf', 'file_path' => '1745410359_2103_20250423_142540.pdf', 'uploaded_at' => '2025-04-23 12:12:39'],
            ['id' => 230, 'record_id' => 130, 'file_name' => 'INV_2025_02659.pdf', 'file_path' => '1745410509_INV_2025_02659.pdf', 'uploaded_at' => '2025-04-23 12:15:09'],
            ['id' => 231, 'record_id' => 130, 'file_name' => 'BDN-02659.pdf', 'file_path' => '1745410509_BDN-02659.pdf', 'uploaded_at' => '2025-04-23 12:15:09'],
            ['id' => 232, 'record_id' => 135, 'file_name' => 'S02749.pdf', 'file_path' => '1745479433_S02749.pdf', 'uploaded_at' => '2025-04-24 07:23:53'],
            ['id' => 233, 'record_id' => 136, 'file_name' => 'S02758.pdf', 'file_path' => '1745829382_S02758.pdf', 'uploaded_at' => '2025-04-28 08:36:22'],
            ['id' => 234, 'record_id' => 135, 'file_name' => 'INV_2025_02679.pdf', 'file_path' => '1745829587_INV_2025_02679.pdf', 'uploaded_at' => '2025-04-28 08:39:47'],
            ['id' => 235, 'record_id' => 135, 'file_name' => 'BDN-02679.pdf', 'file_path' => '1745829587_BDN-02679.pdf', 'uploaded_at' => '2025-04-28 08:39:47'],
            ['id' => 236, 'record_id' => 137, 'file_name' => 'S02777.pdf', 'file_path' => '1745840837_S02777.pdf', 'uploaded_at' => '2025-04-28 11:47:17'],
            ['id' => 237, 'record_id' => 132, 'file_name' => 'INV_2025_02684.pdf', 'file_path' => '1745840911_INV_2025_02684.pdf', 'uploaded_at' => '2025-04-28 11:48:31'],
            ['id' => 238, 'record_id' => 132, 'file_name' => 'BDN-02684.pdf', 'file_path' => '1745840911_BDN-02684.pdf', 'uploaded_at' => '2025-04-28 11:48:31'],
            ['id' => 239, 'record_id' => 90, 'file_name' => '2025.04.29_14.41.39_Export.pdf', 'file_path' => '1745927010_2025.04.29_14.41.39_Export.pdf', 'uploaded_at' => '2025-04-29 11:43:30'],
            ['id' => 240, 'record_id' => 86, 'file_name' => '2025.04.30_11.05.07_Export.pdf', 'file_path' => '1746001389_2025.04.30_11.05.07_Export.pdf', 'uploaded_at' => '2025-04-30 08:23:09'],
            ['id' => 241, 'record_id' => 103, 'file_name' => '2025.04.30_11.05.07_Export.pdf', 'file_path' => '1746001424_2025.04.30_11.05.07_Export.pdf', 'uploaded_at' => '2025-04-30 08:23:44'],
            ['id' => 242, 'record_id' => 138, 'file_name' => 'S02795.pdf', 'file_path' => '1746177147_S02795.pdf', 'uploaded_at' => '2025-05-02 09:12:27'],
            ['id' => 243, 'record_id' => 139, 'file_name' => 'S02798.pdf', 'file_path' => '1746177275_S02798.pdf', 'uploaded_at' => '2025-05-02 09:14:35'],
            ['id' => 244, 'record_id' => 133, 'file_name' => 'INV_2025_02703.pdf', 'file_path' => '1746177349_INV_2025_02703.pdf', 'uploaded_at' => '2025-05-02 09:15:49'],
            ['id' => 245, 'record_id' => 133, 'file_name' => 'BDN-02703.pdf', 'file_path' => '1746177349_BDN-02703.pdf', 'uploaded_at' => '2025-05-02 09:15:49'],
            ['id' => 246, 'record_id' => 92, 'file_name' => '2103_20250505_150343.pdf', 'file_path' => '1746447251_2103_20250505_150343.pdf', 'uploaded_at' => '2025-05-05 12:14:11'],
            ['id' => 247, 'record_id' => 107, 'file_name' => '2103_20250505_150343.pdf', 'file_path' => '1746447279_2103_20250505_150343.pdf', 'uploaded_at' => '2025-05-05 12:14:39'],
            ['id' => 248, 'record_id' => 89, 'file_name' => '2103_20250505_150343.pdf', 'file_path' => '1746447315_2103_20250505_150343.pdf', 'uploaded_at' => '2025-05-05 12:15:15'],
            ['id' => 249, 'record_id' => 134, 'file_name' => '2103_20250505_150343.pdf', 'file_path' => '1746447342_2103_20250505_150343.pdf', 'uploaded_at' => '2025-05-05 12:15:42'],
            ['id' => 250, 'record_id' => 137, 'file_name' => 'INV_2025_02727.pdf', 'file_path' => '1746515292_INV_2025_02727.pdf', 'uploaded_at' => '2025-05-06 07:08:12'],
            ['id' => 251, 'record_id' => 137, 'file_name' => 'BDN-02727.pdf', 'file_path' => '1746515292_BDN-02727.pdf', 'uploaded_at' => '2025-05-06 07:08:12'],
            ['id' => 253, 'record_id' => 138, 'file_name' => 'INV_2025_02734.pdf', 'file_path' => '1746610860_INV_2025_02734.pdf', 'uploaded_at' => '2025-05-07 09:41:00'],
            ['id' => 254, 'record_id' => 138, 'file_name' => 'BDN-02734.pdf', 'file_path' => '1746610860_BDN-02734.pdf', 'uploaded_at' => '2025-05-07 09:41:00'],
            ['id' => 255, 'record_id' => 136, 'file_name' => 'INV_2025_02737.pdf', 'file_path' => '1746611088_INV_2025_02737.pdf', 'uploaded_at' => '2025-05-07 09:44:48'],
            ['id' => 256, 'record_id' => 136, 'file_name' => 'BDN-02737.pdf', 'file_path' => '1746611088_BDN-02737.pdf', 'uploaded_at' => '2025-05-07 09:44:48'],
            ['id' => 257, 'record_id' => 140, 'file_name' => 'S02827.pdf', 'file_path' => '1746611323_S02827.pdf', 'uploaded_at' => '2025-05-07 09:48:43'],
            ['id' => 258, 'record_id' => 141, 'file_name' => 'S02842.pdf', 'file_path' => '1746700327_S02842.pdf', 'uploaded_at' => '2025-05-08 10:32:07'],
            ['id' => 259, 'record_id' => 142, 'file_name' => 'S02843.pdf', 'file_path' => '1746700508_S02843.pdf', 'uploaded_at' => '2025-05-08 10:35:08'],
            ['id' => 260, 'record_id' => 143, 'file_name' => 'S02851.pdf', 'file_path' => '1746700565_S02851.pdf', 'uploaded_at' => '2025-05-08 10:36:05'],
            ['id' => 261, 'record_id' => 139, 'file_name' => 'INV_2025_02750.pdf', 'file_path' => '1747031893_INV_2025_02750.pdf', 'uploaded_at' => '2025-05-12 06:38:13'],
            ['id' => 262, 'record_id' => 139, 'file_name' => 'BDN-02750.pdf', 'file_path' => '1747031893_BDN-02750.pdf', 'uploaded_at' => '2025-05-12 06:38:13'],
            ['id' => 263, 'record_id' => 144, 'file_name' => 'S02869.pdf', 'file_path' => '1747032437_S02869.pdf', 'uploaded_at' => '2025-05-12 06:47:17'],
            ['id' => 264, 'record_id' => 145, 'file_name' => 'S02870.pdf', 'file_path' => '1747032535_S02870.pdf', 'uploaded_at' => '2025-05-12 06:48:55'],
            ['id' => 265, 'record_id' => 146, 'file_name' => 'S02875.pdf', 'file_path' => '1747032691_S02875.pdf', 'uploaded_at' => '2025-05-12 06:51:31'],
            ['id' => 266, 'record_id' => 147, 'file_name' => 'S02856.pdf', 'file_path' => '1747032996_S02856.pdf', 'uploaded_at' => '2025-05-12 06:56:36'],
            ['id' => 267, 'record_id' => 147, 'file_name' => 'INV_2025_02763.pdf', 'file_path' => '1747040954_INV_2025_02763.pdf', 'uploaded_at' => '2025-05-12 09:09:14'],
            ['id' => 268, 'record_id' => 147, 'file_name' => 'BDN-02763.pdf', 'file_path' => '1747040954_BDN-02763.pdf', 'uploaded_at' => '2025-05-12 09:09:14'],
            ['id' => 269, 'record_id' => 148, 'file_name' => 'INV_2025_02492.pdf', 'file_path' => '1747053282_INV_2025_02492.pdf', 'uploaded_at' => '2025-05-12 12:34:42'],
            ['id' => 270, 'record_id' => 148, 'file_name' => 'BDN-02492.pdf', 'file_path' => '1747053282_BDN-02492.pdf', 'uploaded_at' => '2025-05-12 12:34:42'],
            ['id' => 271, 'record_id' => 148, 'file_name' => 'S02548.pdf', 'file_path' => '1747121388_S02548.pdf', 'uploaded_at' => '2025-05-13 07:29:48'],
            ['id' => 272, 'record_id' => 111, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134499_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:08:19'],
            ['id' => 273, 'record_id' => 148, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134525_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:08:45'],
            ['id' => 274, 'record_id' => 115, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134558_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:09:18'],
            ['id' => 275, 'record_id' => 116, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134573_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:09:33'],
            ['id' => 276, 'record_id' => 112, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134600_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:10:00'],
            ['id' => 277, 'record_id' => 108, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134639_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:10:39'],
            ['id' => 278, 'record_id' => 121, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134684_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:11:24'],
            ['id' => 279, 'record_id' => 110, 'file_name' => '2103_20250513_133947.pdf', 'file_path' => '1747134782_2103_20250513_133947.pdf', 'uploaded_at' => '2025-05-13 11:13:02'],
            ['id' => 280, 'record_id' => 143, 'file_name' => 'INV_2025_02779.pdf', 'file_path' => '1747138984_INV_2025_02779.pdf', 'uploaded_at' => '2025-05-13 12:23:04'],
            ['id' => 281, 'record_id' => 143, 'file_name' => 'BDN-02779.pdf', 'file_path' => '1747138984_BDN-02779.pdf', 'uploaded_at' => '2025-05-13 12:23:04'],
            ['id' => 282, 'record_id' => 141, 'file_name' => 'INV_2025_02784.pdf', 'file_path' => '1747206222_INV_2025_02784.pdf', 'uploaded_at' => '2025-05-14 07:03:42'],
            ['id' => 283, 'record_id' => 141, 'file_name' => 'BDN-02784.pdf', 'file_path' => '1747206222_BDN-02784.pdf', 'uploaded_at' => '2025-05-14 07:03:42'],
            ['id' => 284, 'record_id' => 140, 'file_name' => 'INV_2025_02786.pdf', 'file_path' => '1747213457_INV_2025_02786.pdf', 'uploaded_at' => '2025-05-14 09:04:17'],
            ['id' => 285, 'record_id' => 140, 'file_name' => 'BDN-02786.PDF', 'file_path' => '1747213457_BDN-02786.PDF', 'uploaded_at' => '2025-05-14 09:04:17'],
            ['id' => 286, 'record_id' => 149, 'file_name' => 'S02903.pdf', 'file_path' => '1747387796_S02903.pdf', 'uploaded_at' => '2025-05-16 09:29:56'],
            ['id' => 287, 'record_id' => 142, 'file_name' => 'INV_2025_02796.pdf', 'file_path' => '1747387857_INV_2025_02796.pdf', 'uploaded_at' => '2025-05-16 09:30:57'],
            ['id' => 288, 'record_id' => 142, 'file_name' => 'BDN-02796.pdf', 'file_path' => '1747387857_BDN-02796.pdf', 'uploaded_at' => '2025-05-16 09:30:57'],
            ['id' => 289, 'record_id' => 150, 'file_name' => 'S02907.pdf', 'file_path' => '1747650053_S02907.pdf', 'uploaded_at' => '2025-05-19 10:20:53'],
            ['id' => 290, 'record_id' => 150, 'file_name' => 'INV_2025_02817.pdf', 'file_path' => '1747720437_INV_2025_02817.pdf', 'uploaded_at' => '2025-05-20 05:53:57'],
            ['id' => 291, 'record_id' => 150, 'file_name' => 'BDN-02817.pdf', 'file_path' => '1747720437_BDN-02817.pdf', 'uploaded_at' => '2025-05-20 05:53:57'],
            ['id' => 292, 'record_id' => 151, 'file_name' => 'INV_2025_02546_.pdf', 'file_path' => '1747732258_INV_2025_02546_.pdf', 'uploaded_at' => '2025-05-20 09:10:58'],
            ['id' => 293, 'record_id' => 151, 'file_name' => 'BDN-02546.pdf', 'file_path' => '1747732258_BDN-02546.pdf', 'uploaded_at' => '2025-05-20 09:10:58'],
            ['id' => 294, 'record_id' => 151, 'file_name' => 'S02619.pdf', 'file_path' => '1747732258_S02619.pdf', 'uploaded_at' => '2025-05-20 09:10:58'],
            ['id' => 295, 'record_id' => 105, 'file_name' => '2103_20250521_125057.pdf', 'file_path' => '1747827520_2103_20250521_125057.pdf', 'uploaded_at' => '2025-05-21 11:38:40'],
            ['id' => 296, 'record_id' => 114, 'file_name' => 'swift 21-5-2025.pdf', 'file_path' => '1747827584_swift 21-5-2025.pdf', 'uploaded_at' => '2025-05-21 11:39:44'],
            ['id' => 297, 'record_id' => 120, 'file_name' => 'swift 21-5-2025.pdf', 'file_path' => '1747827623_swift 21-5-2025.pdf', 'uploaded_at' => '2025-05-21 11:40:23'],
            ['id' => 298, 'record_id' => 152, 'file_name' => 'S02913.pdf', 'file_path' => '1747828056_S02913.pdf', 'uploaded_at' => '2025-05-21 11:47:36'],
            ['id' => 299, 'record_id' => 146, 'file_name' => 'INV_2025_02820.pdf', 'file_path' => '1747828127_INV_2025_02820.pdf', 'uploaded_at' => '2025-05-21 11:48:47'],
            ['id' => 300, 'record_id' => 146, 'file_name' => 'BDN-02820.pdf', 'file_path' => '1747828127_BDN-02820.pdf', 'uploaded_at' => '2025-05-21 11:48:47'],
        ];

        DB::table('record_attachments')->insert($attachments);
    }

    private function importAttachmentsPart3()
    {
        // Import attachments part 3 (IDs 301-400)
        $attachments = [
            ['id' => 301, 'record_id' => 149, 'file_name' => 'INV_2025_02823.pdf', 'file_path' => '1747828206_INV_2025_02823.pdf', 'uploaded_at' => '2025-05-21 11:50:06'],
            ['id' => 302, 'record_id' => 149, 'file_name' => 'BDN-02823.pdf', 'file_path' => '1747828206_BDN-02823.pdf', 'uploaded_at' => '2025-05-21 11:50:06'],
            ['id' => 303, 'record_id' => 153, 'file_name' => 'S02924.pdf', 'file_path' => '1747828326_S02924.pdf', 'uploaded_at' => '2025-05-21 11:52:06'],
            ['id' => 304, 'record_id' => 154, 'file_name' => 'INV_2025_02837.pdf', 'file_path' => '1748244455_INV_2025_02837.pdf', 'uploaded_at' => '2025-05-26 07:27:35'],
            ['id' => 305, 'record_id' => 154, 'file_name' => 'S02906.pdf', 'file_path' => '1748244455_S02906.pdf', 'uploaded_at' => '2025-05-26 07:27:35'],
            ['id' => 306, 'record_id' => 155, 'file_name' => 'INV_2025_02841.pdf', 'file_path' => '1748247550_INV_2025_02841.pdf', 'uploaded_at' => '2025-05-26 08:19:10'],
            ['id' => 307, 'record_id' => 155, 'file_name' => 'BDN-02841.pdf', 'file_path' => '1748247550_BDN-02841.pdf', 'uploaded_at' => '2025-05-26 08:19:10'],
            ['id' => 308, 'record_id' => 155, 'file_name' => 'S02923.pdf', 'file_path' => '1748247550_S02923.pdf', 'uploaded_at' => '2025-05-26 08:19:10'],
            ['id' => 309, 'record_id' => 156, 'file_name' => 'S02944.pdf', 'file_path' => '1748255744_S02944.pdf', 'uploaded_at' => '2025-05-26 10:35:44'],
            ['id' => 310, 'record_id' => 145, 'file_name' => 'INV_2025_02845.pdf', 'file_path' => '1748331535_INV_2025_02845.pdf', 'uploaded_at' => '2025-05-27 07:38:55'],
            ['id' => 311, 'record_id' => 145, 'file_name' => 'BDN-02845.pdf', 'file_path' => '1748331535_BDN-02845.pdf', 'uploaded_at' => '2025-05-27 07:38:55'],
            ['id' => 312, 'record_id' => 156, 'file_name' => 'INV_2025_02849.pdf', 'file_path' => '1748429558_INV_2025_02849.pdf', 'uploaded_at' => '2025-05-28 10:52:38'],
            ['id' => 313, 'record_id' => 156, 'file_name' => 'BDN-02849.pdf', 'file_path' => '1748429558_BDN-02849.pdf', 'uploaded_at' => '2025-05-28 10:52:38'],
            ['id' => 314, 'record_id' => 123, 'file_name' => 'SWIFT 29-5-2025.pdf', 'file_path' => '1748587793_SWIFT 29-5-2025.pdf', 'uploaded_at' => '2025-05-30 06:49:53'],
            ['id' => 315, 'record_id' => 141, 'file_name' => 'SWIFT 29-5-2025.pdf', 'file_path' => '1748587843_SWIFT 29-5-2025.pdf', 'uploaded_at' => '2025-05-30 06:50:43'],
            ['id' => 316, 'record_id' => 119, 'file_name' => 'SWIFT 29-5-2025.pdf', 'file_path' => '1748587868_SWIFT 29-5-2025.pdf', 'uploaded_at' => '2025-05-30 06:51:08'],
            ['id' => 317, 'record_id' => 157, 'file_name' => 'S02988.pdf', 'file_path' => '1748949781_S02988.pdf', 'uploaded_at' => '2025-06-03 11:23:01'],
            ['id' => 318, 'record_id' => 158, 'file_name' => 'S02989.pdf', 'file_path' => '1749119391_S02989.pdf', 'uploaded_at' => '2025-06-05 10:29:51'],
            ['id' => 319, 'record_id' => 159, 'file_name' => 'S02987.pdf', 'file_path' => '1749119472_S02987.pdf', 'uploaded_at' => '2025-06-05 10:31:12'],
            ['id' => 320, 'record_id' => 160, 'file_name' => 'S03010.pdf', 'file_path' => '1749539168_S03010.pdf', 'uploaded_at' => '2025-06-10 07:06:08'],
            ['id' => 321, 'record_id' => 161, 'file_name' => 'S02953.pdf', 'file_path' => '1749539432_S02953.pdf', 'uploaded_at' => '2025-06-10 07:10:32'],
            ['id' => 322, 'record_id' => 161, 'file_name' => 'INV_2025_02907.pdf', 'file_path' => '1749539432_INV_2025_02907.pdf', 'uploaded_at' => '2025-06-10 07:10:32'],
            ['id' => 323, 'record_id' => 161, 'file_name' => 'BDN-02907.pdf', 'file_path' => '1749539432_BDN-02907.pdf', 'uploaded_at' => '2025-06-10 07:10:32'],
            ['id' => 324, 'record_id' => 158, 'file_name' => 'INV_2025_02908.pdf', 'file_path' => '1749539649_INV_2025_02908.pdf', 'uploaded_at' => '2025-06-10 07:14:09'],
            ['id' => 325, 'record_id' => 158, 'file_name' => 'BDN-02908.pdf', 'file_path' => '1749539649_BDN-02908.pdf', 'uploaded_at' => '2025-06-10 07:14:09'],
            ['id' => 326, 'record_id' => 152, 'file_name' => 'INV_2025_02828.pdf', 'file_path' => '1749539840_INV_2025_02828.pdf', 'uploaded_at' => '2025-06-10 07:17:20'],
            ['id' => 327, 'record_id' => 152, 'file_name' => 'BDN-02828.pdf', 'file_path' => '1749539840_BDN-02828.pdf', 'uploaded_at' => '2025-06-10 07:17:20'],
            ['id' => 328, 'record_id' => 153, 'file_name' => 'INV_2025_02911.pdf', 'file_path' => '1749539915_INV_2025_02911.pdf', 'uploaded_at' => '2025-06-10 07:18:35'],
            ['id' => 329, 'record_id' => 153, 'file_name' => 'BDN-02911.pdf', 'file_path' => '1749539915_BDN-02911.pdf', 'uploaded_at' => '2025-06-10 07:18:35'],
            ['id' => 330, 'record_id' => 102, 'file_name' => 'INV_2025_02416.pdf', 'file_path' => '1749540007_INV_2025_02416.pdf', 'uploaded_at' => '2025-06-10 07:20:07'],
            ['id' => 331, 'record_id' => 102, 'file_name' => 'BDN-02416.pdf', 'file_path' => '1749540007_BDN-02416.pdf', 'uploaded_at' => '2025-06-10 07:20:07'],
            ['id' => 333, 'record_id' => 159, 'file_name' => 'INV_2025_02909.pdf', 'file_path' => '1749545406_INV_2025_02909.pdf', 'uploaded_at' => '2025-06-10 08:50:06'],
            ['id' => 334, 'record_id' => 159, 'file_name' => 'BDN-02909.pdf', 'file_path' => '1749545406_BDN-02909.pdf', 'uploaded_at' => '2025-06-10 08:50:06'],
            ['id' => 335, 'record_id' => 151, 'file_name' => 'SWIFT 10-6-2025.pdf', 'file_path' => '1749550809_SWIFT 10-6-2025.pdf', 'uploaded_at' => '2025-06-10 10:20:09'],
            ['id' => 336, 'record_id' => 113, 'file_name' => 'SWIFT 10-6-2025.pdf', 'file_path' => '1749550827_SWIFT 10-6-2025.pdf', 'uploaded_at' => '2025-06-10 10:20:27'],
            ['id' => 337, 'record_id' => 102, 'file_name' => 'SWIFT 10-6-2025.pdf', 'file_path' => '1749550849_SWIFT 10-6-2025.pdf', 'uploaded_at' => '2025-06-10 10:20:49'],
            ['id' => 338, 'record_id' => 126, 'file_name' => 'SWIFT 10-6-2025.pdf', 'file_path' => '1749550880_SWIFT 10-6-2025.pdf', 'uploaded_at' => '2025-06-10 10:21:20'],
            ['id' => 339, 'record_id' => 122, 'file_name' => 'SWIFT 10-6-2025.pdf', 'file_path' => '1749550906_SWIFT 10-6-2025.pdf', 'uploaded_at' => '2025-06-10 10:21:46'],
            ['id' => 340, 'record_id' => 117, 'file_name' => 'SWIFT 10-6-2025.pdf', 'file_path' => '1749550947_SWIFT 10-6-2025.pdf', 'uploaded_at' => '2025-06-10 10:22:27'],
            ['id' => 341, 'record_id' => 163, 'file_name' => 'S03033.pdf', 'file_path' => '1749714165_S03033.pdf', 'uploaded_at' => '2025-06-12 07:42:45'],
            ['id' => 342, 'record_id' => 164, 'file_name' => 'S03035.pdf', 'file_path' => '1749714268_S03035.pdf', 'uploaded_at' => '2025-06-12 07:44:28'],
            ['id' => 343, 'record_id' => 165, 'file_name' => 'S03036.pdf', 'file_path' => '1749802339_S03036.pdf', 'uploaded_at' => '2025-06-13 08:12:19'],
            ['id' => 344, 'record_id' => 166, 'file_name' => 'S03024 (1).pdf', 'file_path' => '1749932373_S03024 (1).pdf', 'uploaded_at' => '2025-06-14 20:19:33'],
            ['id' => 345, 'record_id' => 166, 'file_name' => 'INV_2025_02935.pdf', 'file_path' => '1750055521_INV_2025_02935.pdf', 'uploaded_at' => '2025-06-16 06:32:01'],
            ['id' => 346, 'record_id' => 166, 'file_name' => 'BDN-02935.pdf', 'file_path' => '1750055521_BDN-02935.pdf', 'uploaded_at' => '2025-06-16 06:32:01'],
            ['id' => 347, 'record_id' => 167, 'file_name' => 'S03031.pdf', 'file_path' => '1750062747_S03031.pdf', 'uploaded_at' => '2025-06-16 08:32:27'],
            ['id' => 348, 'record_id' => 125, 'file_name' => '2025.06.16_13.23.00_Export.pdf', 'file_path' => '1750071348_2025.06.16_13.23.00_Export.pdf', 'uploaded_at' => '2025-06-16 10:55:48'],
            ['id' => 349, 'record_id' => 127, 'file_name' => '2025.06.16_13.23.00_Export.pdf', 'file_path' => '1750071364_2025.06.16_13.23.00_Export.pdf', 'uploaded_at' => '2025-06-16 10:56:04'],
            ['id' => 350, 'record_id' => 164, 'file_name' => 'INV_2025_02962 (1).pdf', 'file_path' => '1750410166_INV_2025_02962 (1).pdf', 'uploaded_at' => '2025-06-20 09:02:46'],
            ['id' => 351, 'record_id' => 164, 'file_name' => 'BDN-02962.pdf', 'file_path' => '1750410166_BDN-02962.pdf', 'uploaded_at' => '2025-06-20 09:02:46'],
            ['id' => 352, 'record_id' => 168, 'file_name' => 'S03073.pdf', 'file_path' => '1750411664_S03073.pdf', 'uploaded_at' => '2025-06-20 09:27:44'],
            ['id' => 353, 'record_id' => 163, 'file_name' => 'INV_2025_02966.pdf', 'file_path' => '1750668586_INV_2025_02966.pdf', 'uploaded_at' => '2025-06-23 08:49:46'],
            ['id' => 354, 'record_id' => 163, 'file_name' => 'BDN-02966.pdf', 'file_path' => '1750668586_BDN-02966.pdf', 'uploaded_at' => '2025-06-23 08:49:46'],
            ['id' => 355, 'record_id' => 157, 'file_name' => 'INV_2025_02968.pdf', 'file_path' => '1750668930_INV_2025_02968.pdf', 'uploaded_at' => '2025-06-23 08:55:30'],
            ['id' => 356, 'record_id' => 157, 'file_name' => 'BDN-02968.pdf', 'file_path' => '1750668930_BDN-02968.pdf', 'uploaded_at' => '2025-06-23 08:55:30'],
            ['id' => 357, 'record_id' => 167, 'file_name' => 'INV_2025_02969.pdf', 'file_path' => '1750669063_INV_2025_02969.pdf', 'uploaded_at' => '2025-06-23 08:57:43'],
            ['id' => 358, 'record_id' => 167, 'file_name' => 'BDN-02969.pdf', 'file_path' => '1750669063_BDN-02969.pdf', 'uploaded_at' => '2025-06-23 08:57:43'],
            ['id' => 359, 'record_id' => 169, 'file_name' => 'S03093.pdf', 'file_path' => '1750852734_S03093.pdf', 'uploaded_at' => '2025-06-25 11:58:54'],
            ['id' => 360, 'record_id' => 128, 'file_name' => 'SWIFT 24-6-2025.pdf', 'file_path' => '1750852990_SWIFT 24-6-2025.pdf', 'uploaded_at' => '2025-06-25 12:03:10'],
            ['id' => 361, 'record_id' => 130, 'file_name' => 'SWIFT 24-6-2025.pdf', 'file_path' => '1750853011_SWIFT 24-6-2025.pdf', 'uploaded_at' => '2025-06-25 12:03:31'],
            ['id' => 362, 'record_id' => 124, 'file_name' => 'SWIFT 24-6-2025.pdf', 'file_path' => '1750853031_SWIFT 24-6-2025.pdf', 'uploaded_at' => '2025-06-25 12:03:51'],
            ['id' => 363, 'record_id' => 132, 'file_name' => 'SWIFT 24-6-2025.pdf', 'file_path' => '1750853065_SWIFT 24-6-2025.pdf', 'uploaded_at' => '2025-06-25 12:04:25'],
            ['id' => 364, 'record_id' => 133, 'file_name' => 'SWIFT 24-6-2025.pdf', 'file_path' => '1750853092_SWIFT 24-6-2025.pdf', 'uploaded_at' => '2025-06-25 12:04:52'],
            ['id' => 365, 'record_id' => 136, 'file_name' => 'SWIFT 24-6-2025.pdf', 'file_path' => '1750853133_SWIFT 24-6-2025.pdf', 'uploaded_at' => '2025-06-25 12:05:33'],
            ['id' => 366, 'record_id' => 129, 'file_name' => '2103_20250625_145651.pdf', 'file_path' => '1750853661_2103_20250625_145651.pdf', 'uploaded_at' => '2025-06-25 12:14:21'],
            ['id' => 367, 'record_id' => 131, 'file_name' => '2103_20250625_145651.pdf', 'file_path' => '1750853692_2103_20250625_145651.pdf', 'uploaded_at' => '2025-06-25 12:14:52'],
            ['id' => 368, 'record_id' => 160, 'file_name' => 'INV_2025_02984.pdf', 'file_path' => '1750922630_INV_2025_02984.pdf', 'uploaded_at' => '2025-06-26 07:23:50'],
            ['id' => 369, 'record_id' => 160, 'file_name' => 'BDN-02984.pdf', 'file_path' => '1750922630_BDN-02984.pdf', 'uploaded_at' => '2025-06-26 07:23:50'],
            ['id' => 370, 'record_id' => 170, 'file_name' => 'S03084.pdf', 'file_path' => '1751015947_S03084.pdf', 'uploaded_at' => '2025-06-27 09:19:07'],
            ['id' => 371, 'record_id' => 171, 'file_name' => 'S03107.pdf', 'file_path' => '1751016056_S03107.pdf', 'uploaded_at' => '2025-06-27 09:20:56'],
            ['id' => 372, 'record_id' => 172, 'file_name' => 'INV_2025_02988.pdf', 'file_path' => '1751272895_INV_2025_02988.pdf', 'uploaded_at' => '2025-06-30 08:41:35'],
            ['id' => 373, 'record_id' => 172, 'file_name' => 'BDN-02988.pdf', 'file_path' => '1751272895_BDN-02988.pdf', 'uploaded_at' => '2025-06-30 08:41:35'],
            ['id' => 374, 'record_id' => 172, 'file_name' => 'S03074.pdf', 'file_path' => '1751272895_S03074.pdf', 'uploaded_at' => '2025-06-30 08:41:35'],
            ['id' => 376, 'record_id' => 138, 'file_name' => 'swift bunker 1-7-2025.pdf', 'file_path' => '1751441460_swift bunker 1-7-2025.pdf', 'uploaded_at' => '2025-07-02 07:31:00'],
            ['id' => 377, 'record_id' => 137, 'file_name' => 'swift bunker 1-7-2025.pdf', 'file_path' => '1751441484_swift bunker 1-7-2025.pdf', 'uploaded_at' => '2025-07-02 07:31:24'],
            ['id' => 378, 'record_id' => 135, 'file_name' => 'swift bunker 1-7-2025.pdf', 'file_path' => '1751441521_swift bunker 1-7-2025.pdf', 'uploaded_at' => '2025-07-02 07:32:01'],
            ['id' => 379, 'record_id' => 140, 'file_name' => 'swift bunker 1-7-2025.pdf', 'file_path' => '1751441546_swift bunker 1-7-2025.pdf', 'uploaded_at' => '2025-07-02 07:32:26'],
            ['id' => 380, 'record_id' => 140, 'file_name' => 'swift bunker 1-7-2025.pdf', 'file_path' => '1751441602_swift bunker 1-7-2025.pdf', 'uploaded_at' => '2025-07-02 07:33:22'],
            ['id' => 381, 'record_id' => 147, 'file_name' => 'swift bunker 1-7-2025.pdf', 'file_path' => '1751441634_swift bunker 1-7-2025.pdf', 'uploaded_at' => '2025-07-02 07:33:54'],
            ['id' => 382, 'record_id' => 170, 'file_name' => 'INV_2025_03002.pdf', 'file_path' => '1751457638_INV_2025_03002.pdf', 'uploaded_at' => '2025-07-02 12:00:38'],
            ['id' => 383, 'record_id' => 170, 'file_name' => 'BDN-03002.pdf', 'file_path' => '1751457638_BDN-03002.pdf', 'uploaded_at' => '2025-07-02 12:00:38'],
            ['id' => 384, 'record_id' => 169, 'file_name' => 'INV_2025_03004.pdf', 'file_path' => '1751527020_INV_2025_03004.pdf', 'uploaded_at' => '2025-07-03 07:17:00'],
            ['id' => 385, 'record_id' => 169, 'file_name' => 'BDN-03004.pdf', 'file_path' => '1751527020_BDN-03004.pdf', 'uploaded_at' => '2025-07-03 07:17:00'],
            ['id' => 386, 'record_id' => 144, 'file_name' => 'INV_2025_02794.pdf', 'file_path' => '1751527218_INV_2025_02794.pdf', 'uploaded_at' => '2025-07-03 07:20:18'],
            ['id' => 387, 'record_id' => 144, 'file_name' => 'BDN-02794.pdf', 'file_path' => '1751527218_BDN-02794.pdf', 'uploaded_at' => '2025-07-03 07:20:18'],
            ['id' => 388, 'record_id' => 174, 'file_name' => 'S03115.pdf', 'file_path' => '1751874795_S03115.pdf', 'uploaded_at' => '2025-07-07 07:53:15'],
            ['id' => 389, 'record_id' => 174, 'file_name' => 'INV_2025_03022.pdf', 'file_path' => '1751874795_INV_2025_03022.pdf', 'uploaded_at' => '2025-07-07 07:53:15'],
            ['id' => 390, 'record_id' => 174, 'file_name' => 'BDN-03022.pdf', 'file_path' => '1751874795_BDN-03022.pdf', 'uploaded_at' => '2025-07-07 07:53:15'],
            ['id' => 391, 'record_id' => 175, 'file_name' => 'S03150 (1).pdf', 'file_path' => '1751970265_S03150 (1).pdf', 'uploaded_at' => '2025-07-08 10:24:25'],
            ['id' => 393, 'record_id' => 142, 'file_name' => 'swift 8-7-2025.pdf', 'file_path' => '1751974110_swift 8-7-2025.pdf', 'uploaded_at' => '2025-07-08 11:28:30'],
            ['id' => 394, 'record_id' => 143, 'file_name' => 'swift 8-7-2025.pdf', 'file_path' => '1751974134_swift 8-7-2025.pdf', 'uploaded_at' => '2025-07-08 11:28:54'],
            ['id' => 395, 'record_id' => 146, 'file_name' => 'swift 8-7-2025.pdf', 'file_path' => '1751974178_swift 8-7-2025.pdf', 'uploaded_at' => '2025-07-08 11:29:38'],
            ['id' => 396, 'record_id' => 176, 'file_name' => 'S03153.pdf', 'file_path' => '1751975881_S03153.pdf', 'uploaded_at' => '2025-07-08 11:58:01'],
            ['id' => 397, 'record_id' => 171, 'file_name' => 'INV_2025_03041.pdf', 'file_path' => '1752048715_INV_2025_03041.pdf', 'uploaded_at' => '2025-07-09 08:11:55'],
            ['id' => 398, 'record_id' => 171, 'file_name' => 'BDN-03041.pdf', 'file_path' => '1752048715_BDN-03041.pdf', 'uploaded_at' => '2025-07-09 08:11:55'],
            ['id' => 399, 'record_id' => 168, 'file_name' => 'INV_2025_03044.pdf', 'file_path' => '1752132370_INV_2025_03044.pdf', 'uploaded_at' => '2025-07-10 07:26:10'],
            ['id' => 400, 'record_id' => 168, 'file_name' => 'BDN-03044.pdf', 'file_path' => '1752132370_BDN-03044.pdf', 'uploaded_at' => '2025-07-10 07:26:10'],
        ];

        DB::table('record_attachments')->insert($attachments);
    }

    private function importAttachmentsPart4()
    {
        // Import attachments part 4 (IDs 401-458)
        $attachments = [
            ['id' => 401, 'record_id' => 175, 'file_name' => 'INV_2025_03045.pdf', 'file_path' => '1752132956_INV_2025_03045.pdf', 'uploaded_at' => '2025-07-10 07:35:56'],
            ['id' => 402, 'record_id' => 175, 'file_name' => 'BDN-03045.pdf', 'file_path' => '1752132956_BDN-03045.pdf', 'uploaded_at' => '2025-07-10 07:35:56'],
            ['id' => 403, 'record_id' => 177, 'file_name' => 'S03141 (1).pdf', 'file_path' => '1752223878_S03141 (1).pdf', 'uploaded_at' => '2025-07-11 08:51:18'],
            ['id' => 404, 'record_id' => 178, 'file_name' => 'S03174.pdf', 'file_path' => '1752489950_S03174.pdf', 'uploaded_at' => '2025-07-14 10:45:50'],
            ['id' => 405, 'record_id' => 179, 'file_name' => 'S03158.pdf', 'file_path' => '1752490026_S03158.pdf', 'uploaded_at' => '2025-07-14 10:47:06'],
            ['id' => 406, 'record_id' => 180, 'file_name' => 'S03139.pdf', 'file_path' => '1752559774_S03139.pdf', 'uploaded_at' => '2025-07-15 06:09:34'],
            ['id' => 407, 'record_id' => 176, 'file_name' => 'INV_2025_03059 (3).pdf', 'file_path' => '1752559858_INV_2025_03059 (3).pdf', 'uploaded_at' => '2025-07-15 06:10:58'],
            ['id' => 408, 'record_id' => 176, 'file_name' => 'BDN-03059 (1).pdf', 'file_path' => '1752559858_BDN-03059 (1).pdf', 'uploaded_at' => '2025-07-15 06:10:58'],
            ['id' => 409, 'record_id' => 177, 'file_name' => 'INV_2025_03066.pdf', 'file_path' => '1752559935_INV_2025_03066.pdf', 'uploaded_at' => '2025-07-15 06:12:15'],
            ['id' => 410, 'record_id' => 177, 'file_name' => 'BDN-03066.pdf', 'file_path' => '1752559935_BDN-03066.pdf', 'uploaded_at' => '2025-07-15 06:12:15'],
            ['id' => 411, 'record_id' => 181, 'file_name' => 'INV_2025_02765.pdf', 'file_path' => '1752564213_INV_2025_02765.pdf', 'uploaded_at' => '2025-07-15 07:23:33'],
            ['id' => 412, 'record_id' => 181, 'file_name' => 'BDN-02765.pdf', 'file_path' => '1752564213_BDN-02765.pdf', 'uploaded_at' => '2025-07-15 07:23:33'],
            ['id' => 413, 'record_id' => 181, 'file_name' => 'S02857.pdf', 'file_path' => '1752564213_S02857.pdf', 'uploaded_at' => '2025-07-15 07:23:33'],
            ['id' => 414, 'record_id' => 179, 'file_name' => 'BDN-03069 (1).pdf', 'file_path' => '1752576431_BDN-03069 (1).pdf', 'uploaded_at' => '2025-07-15 10:47:11'],
            ['id' => 415, 'record_id' => 179, 'file_name' => 'INV_2025_03069.pdf', 'file_path' => '1752576431_INV_2025_03069.pdf', 'uploaded_at' => '2025-07-15 10:47:11'],
            ['id' => 416, 'record_id' => 180, 'file_name' => 'INV_2025_03076 (3).pdf', 'file_path' => '1752654127_INV_2025_03076 (3).pdf', 'uploaded_at' => '2025-07-16 08:22:07'],
            ['id' => 417, 'record_id' => 180, 'file_name' => 'BDN-03076.pdf', 'file_path' => '1752654127_BDN-03076.pdf', 'uploaded_at' => '2025-07-16 08:22:07'],
            ['id' => 418, 'record_id' => 139, 'file_name' => 'swift 16-7-2025.pdf', 'file_path' => '1752664474_swift 16-7-2025.pdf', 'uploaded_at' => '2025-07-16 11:14:34'],
            ['id' => 419, 'record_id' => 144, 'file_name' => 'swift 16-7-2025.pdf', 'file_path' => '1752664518_swift 16-7-2025.pdf', 'uploaded_at' => '2025-07-16 11:15:18'],
            ['id' => 420, 'record_id' => 161, 'file_name' => 'swift 16-7-2025.pdf', 'file_path' => '1752664549_swift 16-7-2025.pdf', 'uploaded_at' => '2025-07-16 11:15:49'],
            ['id' => 421, 'record_id' => 178, 'file_name' => 'INV_2025_03081.pdf', 'file_path' => '1752740491_INV_2025_03081.pdf', 'uploaded_at' => '2025-07-17 08:21:31'],
            ['id' => 422, 'record_id' => 178, 'file_name' => 'BDN-03081.pdf', 'file_path' => '1752740491_BDN-03081.pdf', 'uploaded_at' => '2025-07-17 08:21:31'],
            ['id' => 423, 'record_id' => 150, 'file_name' => 'SWIFT 17-7-2025.pdf', 'file_path' => '1752755560_SWIFT 17-7-2025.pdf', 'uploaded_at' => '2025-07-17 12:32:40'],
            ['id' => 424, 'record_id' => 154, 'file_name' => 'SWIFT 17-7-2025.pdf', 'file_path' => '1752755594_SWIFT 17-7-2025.pdf', 'uploaded_at' => '2025-07-17 12:33:14'],
            ['id' => 425, 'record_id' => 181, 'file_name' => 'SWIFT 17-7-2025.pdf', 'file_path' => '1752755620_SWIFT 17-7-2025.pdf', 'uploaded_at' => '2025-07-17 12:33:40'],
            ['id' => 426, 'record_id' => 182, 'file_name' => 'S03200 (1).pdf', 'file_path' => '1752836528_S03200 (1).pdf', 'uploaded_at' => '2025-07-18 11:02:08'],
            ['id' => 427, 'record_id' => 183, 'file_name' => 'S03201 (1).pdf', 'file_path' => '1752843974_S03201 (1).pdf', 'uploaded_at' => '2025-07-18 13:06:14'],
            ['id' => 430, 'record_id' => 155, 'file_name' => 'swift 8-7-2025.pdf', 'file_path' => '1753181371_swift 8-7-2025.pdf', 'uploaded_at' => '2025-07-22 10:49:31'],
            ['id' => 431, 'record_id' => 183, 'file_name' => 'INV_2025_03105 (3).pdf', 'file_path' => '1753181481_INV_2025_03105 (3).pdf', 'uploaded_at' => '2025-07-22 10:51:21'],
            ['id' => 432, 'record_id' => 183, 'file_name' => 'BDN-03105.pdf', 'file_path' => '1753181481_BDN-03105.pdf', 'uploaded_at' => '2025-07-22 10:51:21'],
            ['id' => 433, 'record_id' => 182, 'file_name' => 'BDN-03111 (1).pdf', 'file_path' => '1753340847_BDN-03111 (1).pdf', 'uploaded_at' => '2025-07-24 07:07:27'],
            ['id' => 434, 'record_id' => 182, 'file_name' => 'INV_2025_03111 (3).pdf', 'file_path' => '1753340921_INV_2025_03111 (3).pdf', 'uploaded_at' => '2025-07-24 07:08:41'],
            ['id' => 435, 'record_id' => 173, 'file_name' => 'S03116 (3).pdf', 'file_path' => '1753438368_S03116 (3).pdf', 'uploaded_at' => '2025-07-25 10:12:48'],
            ['id' => 436, 'record_id' => 184, 'file_name' => 'S03226 (1).pdf', 'file_path' => '1753686474_S03226 (1).pdf', 'uploaded_at' => '2025-07-28 07:07:54'],
            ['id' => 437, 'record_id' => 185, 'file_name' => 'INV_2025_03123 (1).pdf', 'file_path' => '1753686947_INV_2025_03123 (1).pdf', 'uploaded_at' => '2025-07-28 07:15:47'],
            ['id' => 438, 'record_id' => 185, 'file_name' => 'S03223 (3).pdf', 'file_path' => '1753686959_S03223 (3).pdf', 'uploaded_at' => '2025-07-28 07:15:59'],
            ['id' => 439, 'record_id' => 185, 'file_name' => 'BDN-03123 (1).pdf', 'file_path' => '1753686982_BDN-03123 (1).pdf', 'uploaded_at' => '2025-07-28 07:16:22'],
            ['id' => 440, 'record_id' => 186, 'file_name' => 'S03238 (1).pdf', 'file_path' => '1753701350_S03238 (1).pdf', 'uploaded_at' => '2025-07-28 11:15:50'],
            ['id' => 441, 'record_id' => 187, 'file_name' => 'S03239 (1).pdf', 'file_path' => '1753701445_S03239 (1).pdf', 'uploaded_at' => '2025-07-28 11:17:25'],
            ['id' => 442, 'record_id' => 188, 'file_name' => 'S03241 (1).pdf', 'file_path' => '1753781344_S03241 (1).pdf', 'uploaded_at' => '2025-07-29 09:29:04'],
            ['id' => 443, 'record_id' => 189, 'file_name' => 'S03248 (1).pdf', 'file_path' => '1753862625_S03248 (1).pdf', 'uploaded_at' => '2025-07-30 08:03:45'],
            ['id' => 444, 'record_id' => 152, 'file_name' => 'swift 29-7-2025.pdf', 'file_path' => '1753863695_swift 29-7-2025.pdf', 'uploaded_at' => '2025-07-30 08:21:35'],
            ['id' => 445, 'record_id' => 153, 'file_name' => 'swift 29-7-2025.pdf', 'file_path' => '1753863722_swift 29-7-2025.pdf', 'uploaded_at' => '2025-07-30 08:22:02'],
            ['id' => 446, 'record_id' => 149, 'file_name' => 'swift 29-7-2025.pdf', 'file_path' => '1753863758_swift 29-7-2025.pdf', 'uploaded_at' => '2025-07-30 08:22:38'],
            ['id' => 447, 'record_id' => 156, 'file_name' => 'swift 29-7-2025.pdf', 'file_path' => '1753863790_swift 29-7-2025.pdf', 'uploaded_at' => '2025-07-30 08:23:10'],
            ['id' => 448, 'record_id' => 145, 'file_name' => 'swift 29-7-2025.pdf', 'file_path' => '1753863812_swift 29-7-2025.pdf', 'uploaded_at' => '2025-07-30 08:23:32'],
            ['id' => 449, 'record_id' => 173, 'file_name' => 'INV_2025_03142 (1).pdf', 'file_path' => '1753959278_INV_2025_03142 (1).pdf', 'uploaded_at' => '2025-07-31 10:54:38'],
            ['id' => 450, 'record_id' => 173, 'file_name' => 'BDN-03142 (1).pdf', 'file_path' => '1753959296_BDN-03142 (1).pdf', 'uploaded_at' => '2025-07-31 10:54:56'],
            ['id' => 451, 'record_id' => 186, 'file_name' => 'BDN-03144 (1).pdf', 'file_path' => '1754035875_BDN-03144 (1).pdf', 'uploaded_at' => '2025-08-01 08:11:15'],
            ['id' => 452, 'record_id' => 186, 'file_name' => 'INV_2025_03144 (3).pdf', 'file_path' => '1754035889_INV_2025_03144 (3).pdf', 'uploaded_at' => '2025-08-01 08:11:29'],
            ['id' => 455, 'record_id' => 188, 'file_name' => 'INV_2025_03148 (1).pdf', 'file_path' => '1754290989_INV_2025_03148 (1).pdf', 'uploaded_at' => '2025-08-04 07:03:09'],
            ['id' => 456, 'record_id' => 188, 'file_name' => 'BDN-03148 (1).pdf', 'file_path' => '1754291226_BDN-03148 (1).pdf', 'uploaded_at' => '2025-08-04 07:07:06'],
            ['id' => 457, 'record_id' => 189, 'file_name' => 'INV_2025_03149 (1).pdf', 'file_path' => '1754292232_INV_2025_03149 (1).pdf', 'uploaded_at' => '2025-08-04 07:23:52'],
            ['id' => 458, 'record_id' => 189, 'file_name' => 'BDN-03149 (1).pdf', 'file_path' => '1754292246_BDN-03149 (1).pdf', 'uploaded_at' => '2025-08-04 07:24:06'],
        ];

        DB::table('record_attachments')->insert($attachments);
    }
}
