<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            ['setting_name' => 'warning_days', 'setting_value' => '8'],
            ['setting_name' => 'critical_days', 'setting_value' => '5'],
        ];

        foreach ($settings as $setting) {
            Setting::firstOrCreate(['setting_name' => $setting['setting_name']], $setting);
        }
    }
}
