<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\StatusOption;

class StatusOptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $statuses = [
            ['name' => 'Pending', 'color' => '#fbbf24', 'is_paid_status' => false],
            ['name' => 'Paid', 'color' => '#10b981', 'is_paid_status' => true],
            ['name' => 'Overdue', 'color' => '#ef4444', 'is_paid_status' => false],
            ['name' => 'Processing', 'color' => '#3b82f6', 'is_paid_status' => false],
            ['name' => 'Cancelled', 'color' => '#6b7280', 'is_paid_status' => false],
        ];

        foreach ($statuses as $status) {
            StatusOption::firstOrCreate(['name' => $status['name']], $status);
        }
    }
}
