<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Edit Vessel: ') . $vessel->name }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('vessels.show', $vessel) }}" class="bg-gray-800 hover:bg-gray-900 text-white font-medium py-2 px-4 rounded border border-gray-800">
                    Back to Vessel
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('vessels.update', $vessel) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="mb-6">
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Vessel Name *</label>
                            <input type="text" name="name" id="name" value="{{ old('name', $vessel->name) }}" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                   placeholder="Enter vessel name">
                            @error('name')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex justify-end space-x-3">
                            <a href="{{ route('vessels.show', $vessel) }}"
                               class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium py-2 px-4 rounded border border-gray-300">
                                Cancel
                            </a>
                            <button type="submit"
                                    class="bg-gray-800 hover:bg-gray-900 text-white font-medium py-2 px-4 rounded border border-gray-800">
                                Update Vessel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
