<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\VesselController;
use App\Http\Controllers\VesselRecordController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\AttachmentController;
use Illuminate\Support\Facades\Route;

Route::get('/', [DashboardController::class, 'index'])->middleware(['auth', 'verified']);

Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    Route::resource('vessels', VesselController::class);
    Route::resource('vessel-records', VesselRecordController::class);
    Route::get('/records', [VesselRecordController::class, 'index'])->name('vessel-records.index');
    Route::get('/vessels/{vessel}/records', [VesselRecordController::class, 'vesselRecords'])->name('vessels.records');
    
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingController::class, 'update'])->name('settings.update');

    // Status management routes
    Route::post('/settings/statuses', [SettingController::class, 'storeStatus'])->name('settings.statuses.store');
    Route::put('/settings/statuses/{status}', [SettingController::class, 'updateStatus'])->name('settings.statuses.update');
    Route::delete('/settings/statuses/{status}', [SettingController::class, 'destroyStatus'])->name('settings.statuses.destroy');

    Route::get('/paid-records', [VesselRecordController::class, 'paidRecords'])->name('paid-records.index');

    // Export routes
    Route::get('/export/all', [ExportController::class, 'exportAll'])->name('export.all');
    Route::post('/export/report', [ExportController::class, 'exportReport'])->name('export.report');

    // Search routes
    Route::get('/search', [SearchController::class, 'search'])->name('search');

    // Attachment routes
    Route::post('/vessel-records/{vesselRecord}/attachments', [AttachmentController::class, 'store'])->name('attachments.store');
    Route::get('/attachments/{attachment}/download', [AttachmentController::class, 'download'])->name('attachments.download');
    Route::get('/attachments/{attachment}/preview', [AttachmentController::class, 'preview'])->name('attachments.preview');
    Route::delete('/attachments/{attachment}', [AttachmentController::class, 'destroy'])->name('attachments.destroy');
});

require __DIR__.'/auth.php';
