<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Record: <?php echo e($vesselRecord->invoice_no); ?>

            </h2>
            <div class="flex space-x-2">
                <a href="<?php echo e(route('dashboard')); ?>" class="bg-gray-800 hover:bg-gray-900 text-white font-medium py-2 px-4 rounded border border-gray-800">
                    Back to Dashboard
                </a>
                <a href="<?php echo e(route('vessel-records.edit', $vesselRecord)); ?>" class="bg-gray-800 hover:bg-gray-900 text-white font-medium py-2 px-4 rounded border border-gray-800">
                    Edit Record
                </a>
                <form method="POST" action="<?php echo e(route('vessel-records.destroy', $vesselRecord)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to delete this record?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-medium py-2 px-4 rounded border border-red-600">
                        Delete Record
                    </button>
                </form>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="max-w-none mx-auto sm:px-6 lg:px-8" style="max-width: 100rem;">
            <!-- Single Row Layout - Everything Side by Side -->
            <div class="bg-white overflow-hidden shadow-lg sm:rounded-lg">
                <div class="p-8">
                    <!-- Single Row Layout - All Information Side by Side -->
                    <div class="space-y-6">

                        <!-- TRUE Horizontal Layout - Table Style -->
                        <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                            <div class="bg-gray-50 px-6 py-4 border-b border-gray-200">
                                <h3 class="text-xl font-semibold text-gray-900">Record Details</h3>
                            </div>

                            <!-- Single Horizontal Row -->
                            <div class="p-6">
                                <div class="overflow-x-auto">
                                    <table class="w-full">
                                        <thead>
                                            <tr class="border-b border-gray-200">
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Vessel</th>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Invoice</th>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Port</th>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Company</th>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Amount</th>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Date</th>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Status</th>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Due Date</th>
                                                <?php if($vesselRecord->description): ?>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Description</th>
                                                <?php endif; ?>
                                                <th class="text-left py-2 px-4 text-xs font-medium text-gray-500 uppercase tracking-wide">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="py-4 px-4 text-lg font-semibold text-gray-900"><?php echo e($vesselRecord->vessel->name ?? 'N/A'); ?></td>
                                                <td class="py-4 px-4 text-lg font-semibold text-gray-900"><?php echo e($vesselRecord->invoice_no ?? 'N/A'); ?></td>
                                                <td class="py-4 px-4 text-lg font-semibold text-gray-900"><?php echo e($vesselRecord->port ?? 'N/A'); ?></td>
                                                <td class="py-4 px-4 text-lg font-semibold text-gray-900"><?php echo e($vesselRecord->company ?? 'N/A'); ?></td>
                                                <td class="py-4 px-4 text-xl font-bold text-green-600">$<?php echo e(number_format($vesselRecord->amount ?? 0, 2)); ?></td>
                                                <td class="py-4 px-4 text-lg font-semibold text-gray-900"><?php echo e($vesselRecord->date ? $vesselRecord->date->format('d/m/Y') : 'N/A'); ?></td>
                                                <td class="py-4 px-4">
                                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                                                        <?php if($vesselRecord->status && $vesselRecord->status->is_paid_status): ?> bg-green-100 text-green-800
                                                        <?php else: ?> bg-gray-100 text-gray-800 <?php endif; ?>">
                                                        <?php echo e($vesselRecord->status->name ?? 'Unpaid'); ?>

                                                    </span>
                                                </td>
                                                <td class="py-4 px-4">
                                                    <?php if($vesselRecord->due_date): ?>
                                                        <?php
                                                            $dueDateStatus = $vesselRecord->due_date_status;
                                                        ?>
                                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                                                            <?php if($dueDateStatus === 'overdue'): ?> bg-red-100 text-red-800
                                                            <?php elseif($dueDateStatus === 'critical'): ?> bg-orange-100 text-orange-800
                                                            <?php elseif($dueDateStatus === 'warning'): ?> bg-yellow-100 text-yellow-800
                                                            <?php else: ?> bg-green-100 text-green-800 <?php endif; ?>">
                                                            <?php echo e($vesselRecord->due_date->format('d/m/Y')); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="text-lg text-gray-400">N/A</span>
                                                    <?php endif; ?>
                                                </td>
                                                <?php if($vesselRecord->description): ?>
                                                <td class="py-4 px-4 text-base text-gray-700 max-w-xs truncate"><?php echo e($vesselRecord->description); ?></td>
                                                <?php endif; ?>
                                                <td class="py-4 px-4">
                                                    <div class="flex space-x-2">
                                                        <a href="<?php echo e(route('vessel-records.edit', $vesselRecord)); ?>"
                                                           class="inline-flex items-center px-3 py-1 border border-blue-300 text-xs font-medium rounded text-blue-700 bg-blue-50 hover:bg-blue-100 transition-colors">
                                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                                            </svg>
                                                            Edit
                                                        </a>
                                                        <a href="<?php echo e(route('vessels.show', $vesselRecord->vessel)); ?>"
                                                           class="inline-flex items-center px-3 py-1 border border-gray-300 text-xs font-medium rounded text-gray-700 bg-gray-50 hover:bg-gray-100 transition-colors">
                                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                                            </svg>
                                                            View
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>



                        <!-- File Attachments Section -->
                        <div class="bg-gray-50 rounded-lg p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-4">File Attachments</h3>
                            <?php if($vesselRecord->attachments->count() > 0): ?>
                                <div class="mb-4">
                                    <p class="text-sm text-gray-600 mb-4"><?php echo e($vesselRecord->attachments->count()); ?> file(s) attached</p>
                                    <div class="space-y-3" id="attachmentsList">
                                        <?php $__currentLoopData = $vesselRecord->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="border border-gray-200 rounded-lg p-4 hover:border-blue-300 transition-colors bg-white" data-attachment-id="<?php echo e($attachment->id); ?>">
                                                <div class="flex items-center justify-between">
                                                    <div class="flex items-center flex-1">
                                                        <svg class="w-5 h-5 text-blue-500 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                        </svg>
                                                        <div class="flex-1">
                                                            <a href="<?php echo e(route('attachments.preview', $attachment)); ?>" target="_blank"
                                                               class="text-sm font-medium text-blue-600 hover:text-blue-800 truncate block">
                                                                <?php echo e($attachment->file_name); ?>

                                                            </a>
                                                            <p class="text-xs text-gray-500">
                                                                <?php echo e($attachment->uploaded_at ? \Carbon\Carbon::parse($attachment->uploaded_at)->format('d/m/Y H:i') : $attachment->created_at->format('d/m/Y H:i')); ?>

                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="flex space-x-2 ml-4">
                                                        <a href="<?php echo e(route('attachments.download', $attachment)); ?>"
                                                           class="inline-flex items-center px-3 py-1 border border-green-300 text-xs font-medium rounded text-green-700 bg-green-50 hover:bg-green-100 transition-colors">
                                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                            </svg>
                                                            Download
                                                        </a>
                                                        <button onclick="deleteAttachment(<?php echo e($attachment->id); ?>)"
                                                                class="inline-flex items-center px-3 py-1 border border-red-300 text-xs font-medium rounded text-red-700 bg-red-50 hover:bg-red-100 transition-colors">
                                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                            </svg>
                                                            Delete
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-6 text-gray-500 bg-white rounded-lg" id="noAttachmentsMessage">
                                    <svg class="mx-auto h-8 w-8 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                    </svg>
                                    <p class="mt-2 text-sm font-medium">No attachments</p>
                                    <p class="text-xs text-gray-400">Files will appear here</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>

        // Delete attachment function
        function deleteAttachment(attachmentId) {
            if (!confirm('Are you sure you want to delete this file?')) {
                return;
            }

            fetch(`/attachments/${attachmentId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Remove the attachment from the DOM
                    const attachmentElement = document.querySelector(`[data-attachment-id="${attachmentId}"]`);
                    if (attachmentElement) {
                        attachmentElement.remove();
                    }

                    // Check if no attachments left
                    const attachmentsList = document.getElementById('attachmentsList');
                    if (attachmentsList && attachmentsList.children.length === 0) {
                        // Show no attachments message
                        window.location.reload();
                    }
                } else {
                    alert('Delete failed: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Delete failed. Please try again.');
            });
        }


    </script>


 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Users\ASUS\Desktop\bunker-app\bunker-laravel-app\resources\views/vessel-records/show.blade.php ENDPATH**/ ?>