<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Certificate extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'category',
        'display_order',
        'category_order',
    ];

    /**
     * Get the vessels for the certificate.
     */
    public function vessels()
    {
        return $this->belongsToMany(Vessel::class, 'vessel_certificates')
            ->withPivot('id', 'id_no', 'vessel_department', 'issued_date', 'expiry_date', 'attachment_path')
            ->withTimestamps();
    }

    /**
     * Get the vessel certificates.
     */
    public function vesselCertificates()
    {
        return $this->hasMany(VesselCertificate::class);
    }
}
