@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h2>Certificates</h2>
        </div>
        <div class="col-md-6 text-end">
            @if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates'))
            <a href="{{ route('certificates.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Certificate
            </a>
            @endif
        </div>
    </div>

    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h5>Certificate List</h5>
                </div>
                <div class="col-md-6">
                    <form action="{{ route('certificates.index') }}" method="GET" class="d-flex">
                        <input type="text" name="search" class="form-control me-2" placeholder="Search certificates..." value="{{ request('search') }}">
                        <button type="submit" class="btn btn-outline-light">Search</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Display Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($certificates as $certificate)
                        <tr>
                            <td>{{ $certificate->id }}</td>
                            <td>{{ $certificate->name }}</td>
                            <td>{{ $certificate->category }}</td>
                            <td>{{ $certificate->display_order }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('certificates.show', $certificate) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i> View
                                    </a>

                                    @if(auth()->user()->is_admin || auth()->user()->hasPermission('manage_certificates'))
                                    <a href="{{ route('certificates.edit', $certificate) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>

                                    <button type="button" class="btn btn-sm btn-danger"
                                            onclick="if(confirm('Are you sure you want to delete this certificate? This will also delete all associated vessel certificates.')) {
                                                document.getElementById('delete-certificate-{{ $certificate->id }}').submit();
                                            }">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>

                                    <form id="delete-certificate-{{ $certificate->id }}" action="{{ route('certificates.destroy', $certificate) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center">No certificates found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>


        </div>
    </div>
</div>
@endsection
