<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-12">
            <h2>Dashboard</h2>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Vessels</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(\App\Models\Vessel::count()); ?></h2>
                        <i class="fas fa-ship fa-3x text-primary"></i>
                    </div>
                    <a href="<?php echo e(route('vessels.index')); ?>" class="btn btn-primary mt-3">View All Vessels</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Certificates</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(\App\Models\VesselCertificate::count()); ?></h2>
                        <i class="fas fa-certificate fa-3x text-success"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Users</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2><?php echo e(\App\Models\User::count()); ?></h2>
                        <i class="fas fa-users fa-3x text-info"></i>
                    </div>
                    <?php if(auth()->user()->is_admin): ?>
                    <a href="<?php echo e(route('users.index')); ?>" class="btn btn-info mt-3">Manage Users</a>
                    <?php else: ?>
                    <p class="mt-3">Only admins can manage users.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Expiring Certificates</h5>
                </div>
                <div class="card-body">
                    <?php
                    $warningSettings = \App\Models\WarningSettings::first();
                    $warningDays = $warningSettings ? $warningSettings->warning_days : 30;
                    $dangerDays = $warningSettings ? $warningSettings->danger_days : 7;

                    $expiringCertificates = \App\Models\VesselCertificate::whereNotNull('expiry_date')
                        ->whereDate('expiry_date', '>=', now())
                        ->whereDate('expiry_date', '<=', now()->addDays($warningDays))
                        ->with(['vessel', 'certificate'])
                        ->orderBy('expiry_date')
                        ->get();
                    ?>

                    <?php if($expiringCertificates->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Vessel</th>
                                    <th>Certificate</th>
                                    <th>Expiry Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expiringCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $daysLeft = (int)$cert->expiry_date->diffInDays(now());
                                    $isDanger = $cert->expiry_date < now()->addDays($dangerDays);
                                ?>
                                <tr>
                                    <td><?php echo e($cert->vessel->name); ?></td>
                                    <td><?php echo e($cert->certificate->name); ?></td>
                                    <td><?php echo e($cert->expiry_date->format('Y-m-d')); ?></td>
                                    <td>
                                        <?php if($isDanger): ?>
                                            <span class="badge bg-danger">Critical - <?php echo e($daysLeft); ?> days</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning text-dark">Warning - <?php echo e($daysLeft); ?> days</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-primary"
                                                onclick="openCertificateModal(<?php echo e($cert->id); ?>, '<?php echo e($cert->vessel->name); ?>', '<?php echo e($cert->certificate->name); ?>')">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <p>No certificates expiring in the next <?php echo e($warningDays); ?> days.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Expired Certificates</h5>
                </div>
                <div class="card-body">
                    <?php
                    $expiredCertificates = \App\Models\VesselCertificate::whereNotNull('expiry_date')
                        ->whereDate('expiry_date', '<', now())
                        ->with(['vessel', 'certificate'])
                        ->orderBy('expiry_date', 'desc')
                        ->get();
                    ?>

                    <?php if($expiredCertificates->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Vessel</th>
                                    <th>Certificate</th>
                                    <th>Expiry Date</th>
                                    <th>Overdue</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expiredCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $daysOverdue = (int)now()->diffInDays($cert->expiry_date);
                                ?>
                                <tr>
                                    <td><?php echo e($cert->vessel->name); ?></td>
                                    <td><?php echo e($cert->certificate->name); ?></td>
                                    <td><?php echo e($cert->expiry_date->format('Y-m-d')); ?></td>
                                    <td>
                                        <span class="badge bg-dark text-white">
                                            <?php echo e($daysOverdue); ?> days overdue
                                        </span>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-primary"
                                                onclick="openCertificateModal(<?php echo e($cert->id); ?>, '<?php echo e($cert->vessel->name); ?>', '<?php echo e($cert->certificate->name); ?>')">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <p>No expired certificates.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Certificate Edit Modal -->
<div class="modal fade" id="editCertificateModal" tabindex="-1" aria-labelledby="editCertificateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editCertificateModalLabel">Edit Certificate</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editCertificateForm" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Vessel</label>
                        <input type="text" class="form-control" id="modalVesselName" readonly>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Certificate</label>
                        <input type="text" class="form-control" id="modalCertificateName" readonly>
                    </div>

                    <div class="mb-3">
                        <label for="modalIdNo" class="form-label">ID Number</label>
                        <input type="text" class="form-control" id="modalIdNo" name="id_no">
                    </div>

                    <div class="mb-3">
                        <label for="modalDepartment" class="form-label">Department</label>
                        <input type="text" class="form-control" id="modalDepartment" name="vessel_department">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modalIssuedDate" class="form-label">Issued Date</label>
                                <input type="date" class="form-control" id="modalIssuedDate" name="issued_date">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="modalExpiryDate" class="form-label">Expiry Date</label>
                                <input type="date" class="form-control" id="modalExpiryDate" name="expiry_date">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="modalAttachment" class="form-label">Certificate File</label>
                        <input type="file" class="form-control" id="modalAttachment" name="attachment" accept=".pdf,.jpg,.jpeg,.png">
                        <div class="form-text">Upload a new file to replace the existing one (optional)</div>
                        <div id="currentAttachment" class="mt-2"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Certificate</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openCertificateModal(certificateId, vesselName, certificateName) {
    // Set basic info
    document.getElementById('modalVesselName').value = vesselName;
    document.getElementById('modalCertificateName').value = certificateName;

    // Set form action
    document.getElementById('editCertificateForm').action = `/vessel-certificates/${certificateId}`;

    // Fetch certificate data
    fetch(`/vessel-certificates/${certificateId}/edit`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const cert = data.certificate;

                // Populate form fields
                document.getElementById('modalIdNo').value = cert.id_no || '';
                document.getElementById('modalDepartment').value = cert.vessel_department || '';
                document.getElementById('modalIssuedDate').value = cert.issued_date || '';
                document.getElementById('modalExpiryDate').value = cert.expiry_date || '';

                // Show current attachment if exists
                const currentAttachmentDiv = document.getElementById('currentAttachment');
                if (cert.attachment_path) {
                    currentAttachmentDiv.innerHTML = `
                        <div class="alert alert-info">
                            <i class="fas fa-file"></i> Current file:
                            <a href="/storage/${cert.attachment_path}" target="_blank" class="alert-link">
                                ${cert.attachment_path.split('/').pop()}
                            </a>
                        </div>
                    `;
                } else {
                    currentAttachmentDiv.innerHTML = '<div class="text-muted">No file currently uploaded</div>';
                }

                // Show modal
                new bootstrap.Modal(document.getElementById('editCertificateModal')).show();
            } else {
                alert('Error loading certificate data: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error loading certificate data');
        });
}

// Handle form submission
document.getElementById('editCertificateForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);
    const actionUrl = this.action;

    fetch(actionUrl, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Close modal
            bootstrap.Modal.getInstance(document.getElementById('editCertificateModal')).hide();

            // Show success message and reload page
            alert('Certificate updated successfully!');
            location.reload();
        } else {
            alert('Error updating certificate: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error updating certificate');
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/ibrahimbchara/Downloads/certificates/vessel-certificates/resources/views/dashboard.blade.php ENDPATH**/ ?>